<?php
/**
 * API Endpoint untuk Login Pengguna
 * Metode: Menyimpan token sesi ke tabel `sesi_pengguna` (Stateful Token)
 * PERINGATAN: Masih menggunakan password teks biasa (TIDAK AMAN).
 */

// Mengatur header
header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Methods: POST, OPTIONS");
header("Access-Control-Allow-Headers: Content-Type, Authorization");
header("Content-Type: application/json; charset=UTF-8");

if ($_SERVER['REQUEST_METHOD'] == 'OPTIONS') {
    http_response_code(200);
    exit();
}

// Fungsi bantuan
function send_json_response($statusCode, $data) {
    ob_start();
    http_response_code($statusCode);
    ob_end_clean();
    echo json_encode($data);
    exit();
}

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    send_json_response(405, ['message' => 'Metode tidak diizinkan.']);
}

try {
    // Konfigurasi Database
    $servername = "localhost";
    $database = "dbkasir";
    $db_user = "root";
    $db_pass = "";

    // Buat koneksi
    $conn = new mysqli($servername, $db_user, $db_pass, $database);
    if ($conn->connect_error) {
        send_json_response(503, ['message' => 'Layanan tidak tersedia.']);
    }
    $conn->set_charset("utf8mb4");

    // Ambil dan validasi input JSON
    $data = json_decode(file_get_contents('php://input'), true);
    if (json_last_error() !== JSON_ERROR_NONE || empty($data['username']) || empty($data['password'])) {
        send_json_response(400, ['message' => 'Input tidak valid.']);
    }

    $username = $data['username'];
    $password = $data['password'];

    // Query untuk mengambil data pengguna
    $sql = "SELECT p.id, p.nama, p.username, p.kata_sandi, p.id_lokasi, p.id_peran, p.is_aktif, r.nama_peran 
            FROM pengguna p
            JOIN peran r ON p.id_peran = r.id
            WHERE p.username = ? 
            LIMIT 1";

    $stmt = $conn->prepare($sql);
    $stmt->bind_param("s", $username);
    $stmt->execute();
    $result = $stmt->get_result();

    if ($result->num_rows === 1) {
        $user = $result->fetch_assoc();

        // PERINGATAN KEAMANAN: Perbandingan password ini tidak aman!
        if ($password == $user['kata_sandi']) {

            if ($user['is_aktif'] != 1) {
                send_json_response(403, ['message' => 'Akun Anda tidak aktif.']);
            }

            // --- PERUBAHAN UTAMA: SIMPAN TOKEN KE TABEL `sesi_pengguna` ---

            // 1. Hapus sesi lama pengguna ini untuk mencegah token ganda
            $deleteSql = "DELETE FROM sesi_pengguna WHERE id_pengguna = ?";
            $deleteStmt = $conn->prepare($deleteSql);
            $deleteStmt->bind_param("i", $user['id']);
            $deleteStmt->execute();
            $deleteStmt->close();

            // 2. Siapkan data sesi baru
            $token = bin2hex(random_bytes(32));
            $id_pengguna = $user['id'];
            $id_lokasi = $user['id_lokasi'];
            $kadaluarsa = date('Y-m-d H:i:s', time() + (60 * 60 * 24)); // Sesi berlaku 1 hari

            // 3. Masukkan sesi baru ke database
            $insertSql = "INSERT INTO sesi_pengguna (id_pengguna, token, id_lokasi, kadaluarsa, dibuat_pada) VALUES (?, ?, ?, ?, NOW())";
            $insertStmt = $conn->prepare($insertSql);
            $insertStmt->bind_param("isis", $id_pengguna, $token, $id_lokasi, $kadaluarsa);
            $insertStmt->execute();
            $insertStmt->close();

            // 4. Update waktu login terakhir di tabel pengguna (ini tetap berguna)
            $updateSql = "UPDATE pengguna SET terakhir_login = NOW(), diperbarui_pada = NOW() WHERE id = ?";
            $updateStmt = $conn->prepare($updateSql);
            $updateStmt->bind_param("i", $user['id']);
            $updateStmt->execute();
            $updateStmt->close();
            // -------------------------------------------------------------------

            // Login berhasil, kirim data dan token yang baru dibuat
            send_json_response(200, [
                'status' => 'success',
                'message' => 'Login berhasil!',
                'data' => [
                    'user_id'   => $user['id'],
                    'nama'      => $user['nama'],
                    'username'  => $user['username'],
                    'id_lokasi' => $user['id_lokasi'],
                    'peran'     => $user['nama_peran'],
                    'token'     => $token // Kirim token yang SAMA dengan yang disimpan di DB
                ]
            ]);

        } else {
            send_json_response(401, ['message' => 'Kombinasi username dan password salah.']);
        }
    } else {
        send_json_response(401, ['message' => 'Kombinasi username dan password salah.']);
    }

    $stmt->close();
    $conn->close();

} catch (Throwable $e) {
    error_log('Fatal error in login API: ' . $e->getMessage());
    send_json_response(500, ['message' => 'Terjadi kesalahan pada server.']);
}
?>