<?php
/**
 * File: sync.php
 * Deskripsi: Versi final dengan perbaikan pada query otentikasi.
 */

header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Methods: GET, OPTIONS");
header("Content-Type: application/json; charset=UTF-8");

if ($_SERVER['REQUEST_METHOD'] == 'OPTIONS') {
    exit();
}

function send_json_response($statusCode, $data) {
    http_response_code($statusCode);
    echo json_encode($data);
    exit();
}

function sanitize_nulls(&$row) {
    foreach ($row as $key => &$value) {
        if ($value === null) {
            $value = "";
        }
    }
}

mysqli_report(MYSQLI_REPORT_ERROR | MYSQLI_REPORT_STRICT);

$table_name = $_GET['table'] ?? 'unknown';

try {
    if (!isset($_GET['token']) || empty($_GET['token'])) {
        send_json_response(401, ['message' => 'Akses ditolak. Token otentikasi tidak ditemukan.']);
    }
    $token = $_GET['token'];

    $conn = new mysqli("localhost", "root", "", "dbkasir");
    $conn->set_charset("utf8mb4");

    // --- PERBAIKAN UTAMA DI SINI ---
    // Tambahkan "s.kadaluarsa" ke dalam SELECT statement
    $sessionSql = "SELECT u.*, p.nama_peran, s.kadaluarsa
                   FROM sesi_pengguna s
                   JOIN pengguna u ON s.id_pengguna = u.id
                   JOIN peran p ON u.id_peran = p.id
                   WHERE s.token = ? LIMIT 1";
    // -------------------------------
                   
    $stmt = $conn->prepare($sessionSql);
    $stmt->bind_param("s", $token);
    $stmt->execute();
    $result = $stmt->get_result();

    if ($result->num_rows !== 1) {
        send_json_response(401, ['message' => 'Sesi tidak valid. Token tidak cocok.']);
    }
    $sessionData = $result->fetch_assoc();
    
    // Pengecekan ini sekarang akan berjalan dengan benar
    if (time() > strtotime($sessionData['kadaluarsa'])) {
        send_json_response(401, ['message' => 'Sesi Anda telah kedaluwarsa.']);
    }
    $stmt->close();
    
    $current_user_id = $sessionData['id'];
    $current_user_role = strtolower($sessionData['nama_peran']);

    if (!isset($_GET['id_lokasi']) || !isset($_GET['table'])) {
        send_json_response(400, ['message' => 'Parameter tidak lengkap.']);
    }

    $id_lokasi = (int)$_GET['id_lokasi'];
    $table_name = $_GET['table'];
    
    $allowed_tables = [
        'produk', 'kategori', 'pelanggan', 'lokasi', 'varian_produk', 
        'harga_jual_cabang', 'stok', 'promo', 'detail_promo', 'harga_grosir', 
        'peran', 'pengguna', 'transaksi', 'detail_transaksi'
    ];
    if (!in_array($table_name, $allowed_tables)) {
        send_json_response(400, ['message' => 'Akses tabel tidak diizinkan.']);
    }

    $base_query = "SELECT * FROM `$table_name`";
    $params = [];
    $types = "";

    switch ($table_name) {
        case 'produk':
            $sql = "SELECT p.*, k.nama as nama_kategori, s.kuantitas 
                    FROM produk p 
                    LEFT JOIN stok s ON p.id = s.id_produk 
                    LEFT JOIN kategori k ON p.id_kategori = k.id 
                    WHERE p.is_aktif = 1 AND s.id_lokasi = ?";
            $params = [$id_lokasi]; $types = "i";
            break;
            
        case 'pengguna':
            $sql = "SELECT id, nama, username, id_peran, id_lokasi, is_aktif, terakhir_login, dibuat_pada, diperbarui_pada FROM pengguna WHERE id_lokasi = ?";
            $params = [$id_lokasi]; $types = "i";
            break;

        case 'transaksi':
            if ($current_user_role == 'kasir') {
                $sql = "SELECT * FROM transaksi WHERE id_lokasi = ? AND id_kasir = ?";
                $params = [$id_lokasi, $current_user_id];
                $types = "ii";
            } else {
                $sql = "SELECT * FROM transaksi WHERE id_lokasi = ?";
                $params = [$id_lokasi];
                $types = "i";
            }
            break;

        case 'detail_transaksi':
            $sql = "SELECT dt.* FROM detail_transaksi dt JOIN transaksi t ON dt.id_transaksi = t.id WHERE t.id_lokasi = ?";
            $params = [$id_lokasi];
            $types = "i";
            break;

        case 'harga_jual_cabang': 
            $sql = "SELECT * FROM harga_jual_cabang WHERE id_cabang = ?"; 
            $params = [$id_lokasi]; $types = "i"; 
            break;

        case 'stok':
            $sql = "SELECT * FROM stok WHERE id_lokasi = ?";
            $params = [$id_lokasi]; $types = "i"; 
            break;

        case 'kategori': case 'pelanggan': case 'lokasi': case 'peran': case 'varian_produk': case 'harga_grosir': case 'detail_promo': case 'promo': 
            $sql = $base_query; 
            break;
            
        default:
            send_json_response(400, ['message' => "Aturan untuk tabel '$table_name' tidak ditemukan."]);
            break;
    }

    $stmt = $conn->prepare($sql);
    if (!empty($params)) {
        $stmt->bind_param($types, ...$params);
    }
    $stmt->execute();
    $result = $stmt->get_result();
    
    $data = [];
    while ($row = $result->fetch_assoc()) {
        sanitize_nulls($row);
        $data[] = $row;
    }
    
    send_json_response(200, ['message' => "Data '$table_name' berhasil.", 'data' => $data]);
    
    $stmt->close();
    $conn->close();

} catch (Throwable $e) { 
    error_log("Sync API Error for table '$table_name': " . $e->getMessage()); 
    send_json_response(500, ['message' => "Terjadi error di server saat mengambil tabel '$table_name'."]); 
}
?>