<?php
header("Access-Control-Allow-Origin: *");
header("Content-Type: application/json");

include "../koneksi.php"; // sesuaikan dengan file koneksi Anda

// $id_toko = isset($_GET['id_toko']) ? $_GET['id_toko'] : 0;
$id_toko=1;
if ($id_toko == 0) {
    echo json_encode([
        "success" => false,
        "message" => "ID TOKO tidak valid"
    ]);
    exit;
}

// ================= TOTAL TRANSAKSI =================
$qTotal = mysqli_query($conn, "
    SELECT COUNT(*) AS total 
    FROM tb_transaksi 
    WHERE id_toko='$id_toko'
");
$totalTransaksi = mysqli_fetch_assoc($qTotal)['total'];

// ================= TRANSAKSI HARI INI =================
$tanggalHariIni = date('Y-m-d');
$qHariIni = mysqli_query($conn, "
    SELECT COUNT(*) AS total 
    FROM tb_transaksi 
    WHERE id_toko='$id_toko'
    AND DATE(tanggal_transaksi)='$tanggalHariIni'
");
$transaksiHariIni = mysqli_fetch_assoc($qHariIni)['total'];

// ================= OMSET HARI INI =================
$qOmset = mysqli_query($conn, "
    SELECT SUM(total_akhir) AS omset 
    FROM tb_transaksi 
    WHERE id_toko='$id_toko'
    AND DATE(tanggal_transaksi)='$tanggalHariIni'
");
$omset = mysqli_fetch_assoc($qOmset)['omset'] ?? 0;

// ================= PIUTANG =================
$qPiutang = mysqli_query($conn, "
    SELECT SUM(total_akhir - bayar) AS piutang 
    FROM tb_transaksi 
    WHERE id_toko='$id_toko'
    AND status_pembayaran != 'Lunas'
");
$piutang = mysqli_fetch_assoc($qPiutang)['piutang'] ?? 0;

// ================= TRANSAKSI HARI INI LIST =================
$qList = mysqli_query($conn, "
    SELECT 
        t.id_transaksi,
        t.nomor_nota,
        IFNULL(c.nama_customer, 'UMUM') AS customer,
        t.total_akhir,
        t.status_pembayaran
    FROM tb_transaksi t
    LEFT JOIN tb_customer c 
        ON t.id_customer = c.id_customer
    WHERE t.id_toko='$id_toko'
    AND DATE(t.tanggal_transaksi)='$tanggalHariIni'
    ORDER BY t.id_transaksi DESC
    LIMIT 10
");
$transaksiHariIniList = [];
while ($row = mysqli_fetch_assoc($qList)) {
    $transaksiHariIniList[] = [
        "id_transaksi"     => $row['id_transaksi'],
        "nota"     => $row['nomor_nota'],
        "customer" => $row['customer'],
        "total"    => (int)$row['total_akhir'],
        "status"   => $row['status_pembayaran'],
    ];
}

// ================= RESPONSE =================
echo json_encode([
    "success" => true,
    "data" => [
        "total_transaksi" => (int)$totalTransaksi,
        "transaksi_hari_ini" => (int)$transaksiHariIni,
        "omset" => (int)$omset,
        "piutang" => (int)$piutang,
        "transaksi_hari_ini_list" => $transaksiHariIniList
    ]
]);
