<?php
header('Content-Type: application/json');
require_once '../koneksi.php';

$id_customer = $_POST['id_customer'] ?? '';

if ($id_customer == '') {
    echo json_encode([
        'status' => false,
        'message' => 'ID customer wajib diisi'
    ]);
    exit;
}

$sql = "
SELECT
    c.id_customer,
    c.nama,
    c.telepon,
    c.alamat,
    COUNT(t.id_transaksi) AS total_transaksi,
    SUM(t.total) AS total_belanja,
    SUM(
        CASE 
            WHEN t.status_pembayaran = 'PIUTANG'
            THEN (t.total - t.bayar)
            ELSE 0
        END
    ) AS total_piutang
FROM tb_customer c
LEFT JOIN tb_transaksi t 
    ON t.id_customer = c.id_customer
WHERE c.id_customer = '$id_customer'
GROUP BY c.id_customer
LIMIT 1
";

$q = mysqli_query($conn, $sql);
$r = mysqli_fetch_assoc($q);

if (!$r) {
    echo json_encode([
        'status' => false,
        'message' => 'Data tidak ditemukan'
    ]);
    exit;
}

echo json_encode([
    'status' => true,
    'data' => [
        'id_customer'     => (int)$r['id_customer'],
        'nama'            => $r['nama'],
        'telepon'         => $r['telepon'] ?? '-',
        'alamat'          => $r['alamat'] ?? '-',
        'total_transaksi' => (int)$r['total_transaksi'],
        'total_belanja'   => (float)$r['total_belanja'],
        'total_piutang'   => (float)$r['total_piutang'],
    ]
]);
