<?php
header('Content-Type: application/json');
include '../koneksi.php'; // pastikan koneksi $koneksi ada

// $dari    = $_GET['dari'] ?? '';
// $sampai  = $_GET['sampai'] ?? '';
// $idToko  = $_GET['id_toko'] ?? '';

$dari     = $_POST['dari']     ?? '2025-01-01';
$sampai  = $_POST['sampai']   ?? '2025-12-31';
$idToko = $_POST['id_toko']  ?? '1';

if ($dari == '' || $sampai == '' || $idToko == '') {
  echo json_encode([
    'penjualan' => [],
    'pengeluaran' => []
  ]);
  exit;
}

/*
|--------------------------------------------------------------------------
| PENJUALAN (LUNAS + PIUTANG)
|--------------------------------------------------------------------------
| ambil dari tb_transaksi
*/
$penjualan = [];

$qPenjualan = mysqli_query($conn, "
  SELECT
    t.nomor_nota,
    t.tanggal_transaksi,
    IFNULL(c.nama_customer, '-') AS nama_customer,
    t.total_akhir,
    t.status_pembayaran
  FROM tb_transaksi t
  LEFT JOIN tb_customer c 
    ON t.id_customer = c.id_customer
  WHERE t.id_toko = '$idToko'
    AND DATE(t.tanggal_transaksi) BETWEEN '$dari' AND '$sampai'
");

while ($row = mysqli_fetch_assoc($qPenjualan)) {
  $penjualan[] = [
    'nomor_nota'        => $row['nomor_nota'],
    'tanggal_transaksi'=> $row['tanggal_transaksi'],
    'nama_customer'    => $row['nama_customer'],
    'total_akhir'      => $row['total_akhir'], // STRING (AMAN)
    'status_pembayaran'=> $row['status_pembayaran'],
  ];
}

/*
|--------------------------------------------------------------------------
| PENGELUARAN
|--------------------------------------------------------------------------
*/
$pengeluaran = [];

$qPengeluaran = mysqli_query($conn, "
  SELECT
    id_pengeluaran,
    tanggal,
    keterangan,
    nominal_pengeluaran,
    id_toko
  FROM tb_pengeluaran
  WHERE id_toko = '$idToko'
    AND DATE(tanggal) BETWEEN '$dari' AND '$sampai'
");

while ($row = mysqli_fetch_assoc($qPengeluaran)) {
  $pengeluaran[] = [
    'id_pengeluaran'      => $row['id_pengeluaran'],
    'tanggal'             => $row['tanggal'],
    'keterangan'          => $row['keterangan'],
    'nominal_pengeluaran' => $row['nominal_pengeluaran'], // STRING
    'id_toko'             => $row['id_toko'],
  ];
}

/*
|--------------------------------------------------------------------------
| RESPONSE FINAL
|--------------------------------------------------------------------------
*/
echo json_encode([
  'penjualan'   => $penjualan,
  'pengeluaran' => $pengeluaran
]);
