<?php
error_reporting(0);
ini_set('display_errors', 0);

header("Content-Type: application/json");
include "../koneksi.php";

/*
|--------------------------------------------------------------------------
| LOG FUNCTION
|--------------------------------------------------------------------------
*/
function writeLog($msg) {
    file_put_contents(
        __DIR__ . "/laporan_penjualan.log",
        "[" . date("Y-m-d H:i:s") . "] $msg\n",
        FILE_APPEND
    );
}

/*
|--------------------------------------------------------------------------
| PARAMETER
|--------------------------------------------------------------------------
*/
$dari    = $_POST['dari'] ?? '';
$sampai = $_POST['sampai'] ?? '';
$idToko = $_POST['id_toko'] ?? '';
$search = $_POST['search'] ?? '';
$status = $_POST['status'] ?? '';

writeLog("REQ dari=$dari sampai=$sampai toko=$idToko search=$search status=$status");

/*
|--------------------------------------------------------------------------
| VALIDASI
|--------------------------------------------------------------------------
*/
if ($dari === '' || $sampai === '' || $idToko === '') {
    echo json_encode([
        "status" => false,
        "message" => "Parameter wajib tidak lengkap",
        "data" => []
    ]);
    exit;
}

/*
|--------------------------------------------------------------------------
| WHERE CLAUSE
|--------------------------------------------------------------------------
*/
$where = [];
$where[] = "t.id_toko = '" . mysqli_real_escape_string($conn, $idToko) . "'";
$where[] = "DATE(t.tanggal_transaksi) BETWEEN '$dari' AND '$sampai'";

if ($search !== '') {
    $search = mysqli_real_escape_string($conn, $search);
    $where[] = "(t.nomor_nota LIKE '%$search%' OR c.nama_customer LIKE '%$search%')";
}

if ($status !== '') {
    $status = mysqli_real_escape_string($conn, $status);
    $where[] = "t.status_pembayaran = '$status'";
}

$whereSql = implode(" AND ", $where);

/*
|--------------------------------------------------------------------------
| QUERY (JOIN TOKO + CUSTOMER)
|--------------------------------------------------------------------------
*/
$sql = "
SELECT
    t.nomor_nota,
    t.tanggal_transaksi,
    c.nama_customer,
    t.total_akhir,
    t.bayar,
    t.metode_bayar,
    t.status_pembayaran,
    tk.nama_toko
FROM tb_transaksi t
LEFT JOIN tb_customer c ON t.id_customer = c.id_customer
LEFT JOIN tb_toko tk ON t.id_toko = tk.id_toko
WHERE $whereSql
ORDER BY t.tanggal_transaksi DESC
";

writeLog("SQL: $sql");

$q = mysqli_query($conn, $sql);

/*
|--------------------------------------------------------------------------
| INIT
|--------------------------------------------------------------------------
*/
$data = [];

$totalCash     = 0;
$totalTransfer = 0;
$totalPiutang  = 0;
$namaToko      = '';

/*
|--------------------------------------------------------------------------
| LOOP DATA
|--------------------------------------------------------------------------
*/
while ($r = mysqli_fetch_assoc($q)) {

    // ambil nama toko sekali saja
    if ($namaToko === '') {
        $namaToko = $r['nama_toko'] ?? '';
    }

    $totalAkhir  = (float)$r['total_akhir'];
    $bayar       = (float)$r['bayar'];
    $sisa        = max($totalAkhir - $bayar, 0);
    $statusBayar = strtoupper($r['status_pembayaran']);

    // TOTAL PIUTANG = SISA
    if ($statusBayar === 'PIUTANG') {
        $totalPiutang += $sisa;
    }

    // CASH / TRANSFER
    if (strtolower($r['metode_bayar']) === 'cash') {
        $totalCash += $totalAkhir;
    } else {
        $totalTransfer += $totalAkhir;
    }

    $data[] = [
        "nomor_nota"        => $r['nomor_nota'],
        "tanggal_transaksi"=> $r['tanggal_transaksi'],
        "nama_customer"    => $r['nama_customer'] ?? '-',
        "total_akhir"      => $totalAkhir,
        "bayar"            => $bayar,
        "sisa_piutang"     => $sisa,
        "metode_bayar"     => $r['metode_bayar'],
        "status_pembayaran"=> $r['status_pembayaran'],
    ];
}

/*
|--------------------------------------------------------------------------
| RESPONSE JSON
|--------------------------------------------------------------------------
*/
echo json_encode([
    "status"    => true,
    "nama_toko" => $namaToko,
    "summary"   => [
        "total_cash"     => $totalCash,
        "total_transfer" => $totalTransfer,
        "total_piutang"  => $totalPiutang
    ],
    "data" => $data
]);
exit;
