<?php
require_once "../koneksi.php";

$dari    = $_POST['dari'];
$sampai  = $_POST['sampai'];
$idToko  = $_POST['id_toko'];
$search  = $_POST['search'] ?? '';

$whereSearch = "";
if ($search != '') {
    $s = mysqli_real_escape_string($conn, $search);
    $whereSearch = "
        AND (
            c.nama_customer LIKE '%$s%' OR
            c.alamat_customer LIKE '%$s%' OR
            c.nope_customer LIKE '%$s%'
        )
    ";
}

/* ================= DATA ================= */
$sql = "
SELECT 
    c.id_customer,
    c.nama_customer,
    c.alamat_customer,
    c.nope_customer,
    COUNT(t.id_transaksi) AS total_transaksi,
    SUM(t.total_akhir) AS total_penjualan,
    SUM(t.bayar) AS total_bayar,
    SUM(t.total_akhir - t.bayar) AS sisa_piutang
FROM tb_transaksi t
LEFT JOIN tb_customer c ON t.id_customer = c.id_customer
WHERE DATE(t.tanggal_transaksi) BETWEEN '$dari' AND '$sampai'
AND t.id_toko = '$idToko'
$whereSearch
GROUP BY c.id_customer
ORDER BY total_penjualan DESC
";

$q = mysqli_query($conn, $sql);
$data = [];

$totalCash = 0;
$totalTransfer = 0;
$totalPiutang = 0;

while ($row = mysqli_fetch_assoc($q)) {
    $data[] = $row;
    $totalPiutang += $row['sisa_piutang'];
}

/* ================= SUMMARY ================= */
$sum = mysqli_fetch_assoc(mysqli_query($conn, "
SELECT
SUM(CASE WHEN metode_bayar='CASH' THEN total_akhir ELSE 0 END) AS total_cash,
SUM(CASE WHEN metode_bayar='TRANSFER' THEN total_akhir ELSE 0 END) AS total_transfer
FROM tb_transaksi
WHERE DATE(tanggal_transaksi) BETWEEN '$dari' AND '$sampai'
AND id_toko='$idToko'
"));

/* ================= TOKO ================= */
$toko = mysqli_fetch_assoc(mysqli_query($conn, "
SELECT nama_toko FROM tb_toko WHERE id_toko='$idToko'
"));

echo json_encode([
    'nama_toko' => $toko['nama_toko'] ?? '',
    'data' => $data,
    'summary' => [
        'total_cash' => $sum['total_cash'] ?? 0,
        'total_transfer' => $sum['total_transfer'] ?? 0,
        'total_piutang' => $totalPiutang,
    ]
]);
