<?php
header('Content-Type: application/json');
include '../koneksi.php'; // sesuaikan

$dari     = $_POST['dari']     ?? '2025-01-01';
$sampai  = $_POST['sampai']   ?? '2025-12-31';
$id_toko = $_POST['id_toko']  ?? '1';
$search  = $_POST['search']   ?? '';

$where = [];

if ($dari != '' && $sampai != '') {
    $where[] = "t.tanggal_pesan BETWEEN '$dari' AND '$sampai'";
}

if ($id_toko != '') {
    $where[] = "t.id_toko = '$id_toko'";
}

if ($search != '') {
    $where[] = "jc.nama_jenis LIKE '%$search%'";
}

$whereSql = count($where) > 0 ? 'WHERE ' . implode(' AND ', $where) : '';

$sql = "
SELECT 
    jc.nama_jenis,
    js.jenis_satuan,
    SUM(td.qty) AS total_qty,
    SUM(td.sub_total) AS total_omzet
FROM tb_transaksi_detail td
JOIN tb_transaksi t ON td.id_transaksi = t.id_transaksi
JOIN tb_jenis_cetakan jc ON td.id_jenis_cetakan = jc.id_jenis_cetakan
JOIN tb_jenis_satuan js ON jc.id_jenis_satuan = js.id_jenis_satuan
$whereSql
GROUP BY td.id_jenis_cetakan
ORDER BY total_qty DESC
";

$query = mysqli_query($conn, $sql);

$data = [];
while ($row = mysqli_fetch_assoc($query)) {
    $data[] = [
        'nama_jenis'   => $row['nama_jenis'],
        'jenis_satuan' => $row['jenis_satuan'],
        'total_qty'    => (int)$row['total_qty'],
        'total_omzet'  => (float)$row['total_omzet'],
    ];
}

// ================= NAMA TOKO =================
$nama_toko = '';
if ($id_toko != '') {
    $qToko = mysqli_query($conn, "SELECT nama_toko FROM tb_toko WHERE id_toko='$id_toko'");
    if ($r = mysqli_fetch_assoc($qToko)) {
        $nama_toko = $r['nama_toko'];
    }
}

echo json_encode([
    'status'     => true,
    'nama_toko'  => $nama_toko,
    'data'       => $data,
]);
