<?php
header('Content-Type: application/json');
require 'koneksi.php'; // mysqli $conn

$username = $_POST['username'] ?? '';
$password = $_POST['password'] ?? '';

if ($username == '' || $password == '') {
    echo json_encode([
        'status' => false,
        'message' => 'Username & Password wajib diisi'
    ]);
    exit;
}

$sql = "
SELECT 
    u.id_user,
    u.nama,
    u.alamat,
    u.nope,
    u.username,
    u.password,
    u.level,
    t.id_toko,
    t.nama_toko,
    t.alamat_toko,
    t.telp_toko
FROM tb_user u
JOIN tb_toko t ON u.id_toko = t.id_toko
WHERE u.username = ?
LIMIT 1
";

$stmt = $conn->prepare($sql);
$stmt->bind_param("s", $username);
$stmt->execute();
$result = $stmt->get_result();

if ($result->num_rows == 0) {
    echo json_encode([
        'status' => false,
        'message' => 'Username tidak ditemukan'
    ]);
    exit;
}

$user = $result->fetch_assoc();

// ❗ kalau password masih plain text
if ($password != $user['password']) {
    echo json_encode([
        'status' => false,
        'message' => 'Password salah'
    ]);
    exit;
}

// sukses
unset($user['password']);

echo json_encode([
    'status' => true,
    'message' => 'Login berhasil',
    'data' => $user
]);
