<?php
include 'koneksi.php';

/* =========================
   CONFIG LOG
========================= */
$logFile = __DIR__ . '/log_transaksi.txt';
function writeLog($msg) {
  global $logFile;
  file_put_contents(
    $logFile,
    '[' . date('Y-m-d H:i:s') . '] ' . $msg . PHP_EOL,
    FILE_APPEND
  );
}

/* =========================
   HELPER
========================= */
function convertDate($tgl) {
  if (!$tgl) return null;
  $dt = DateTime::createFromFormat('d/m/Y', $tgl);
  return $dt ? $dt->format('Y-m-d') : null;
}

/* =========================
   START
========================= */
writeLog('=== START TRANSAKSI ===');
writeLog('POST: ' . json_encode($_POST));

mysqli_begin_transaction($conn);

try {

  /* =========================
     NORMALISASI DATA
  ========================= */
  $tgl_pesan   = convertDate($_POST['tanggal_pesan'] ?? null);
  $tgl_selesai = convertDate($_POST['tanggal_selesai'] ?? null);

  $id_customer = (!empty($_POST['id_customer']))
    ? (int) $_POST['id_customer']
    : 0;

  $id_designer = (!empty($_POST['id_designer']))
    ? (int) $_POST['id_designer']
    : 0;

  $nominal_designer = (!empty($_POST['nominal_designer']))
    ? (float) $_POST['nominal_designer']
    : 0;

  $potongan = (!empty($_POST['potongan']))
    ? (float) $_POST['potongan']
    : 0;
  $catatan = (!empty($_POST['catatan']))
    ? (string) $_POST['catatan']
    : '';

  writeLog("Parsed: customer=$id_customer designer=$id_designer jasa=$nominal_designer potongan=$potongan");

  /* =========================
     INSERT TRANSAKSI
  ========================= */
  $sql = "
    INSERT INTO tb_transaksi SET
      nomor_nota        = '{$_POST['nomor_nota']}',
      tanggal_pesan     = " . ($tgl_pesan ? "'$tgl_pesan'" : "NULL") . ",
      tanggal_selesai   = " . ($tgl_selesai ? "'$tgl_selesai'" : "NULL") . ",
      tanggal_transaksi= NOW(),
      nominal_designer  = '$nominal_designer',
      potongan          = '$potongan',
      sub_total_produk  = '{$_POST['sub_total_produk']}',
      total_akhir       = '{$_POST['total_akhir']}',
      bayar             = '{$_POST['bayar']}',
      metode_bayar      = '{$_POST['metode_bayar']}',
      status_pembayaran = '{$_POST['status_pembayaran']}',
      status_cetak      = 'BELUM',
      status_barang     = 'BELUM DIAMBIL',
      id_customer       = '$id_customer',
      id_designer       = '$id_designer',
      id_user           = '{$_POST['id_user']}',
      id_toko           = '{$_POST['id_toko']}',
      catatan           = '$catatan'";

  writeLog("SQL TRANSAKSI: $sql");

  if (!mysqli_query($conn, $sql)) {
    throw new Exception(mysqli_error($conn));
  }

  $id_transaksi = mysqli_insert_id($conn);
  writeLog("ID TRANSAKSI: $id_transaksi");

  /* =========================
     INSERT DETAIL
  ========================= */
  $detail = json_decode($_POST['detail'], true);

  if (!is_array($detail)) {
    throw new Exception('Detail transaksi tidak valid');
  }

  foreach ($detail as $d) {
    $sqlDetail = "
      INSERT INTO tb_transaksi_detail SET
        id_transaksi     = '$id_transaksi',
        id_jenis_cetakan = '{$d['id_jenis_cetakan']}',
        qty              = '{$d['qty']}',
        harga            = '{$d['harga']}',
        panjang          = '{$d['panjang']}',
        lebar            = '{$d['lebar']}',
        sub_total        = '{$d['sub_total']}'
    ";

    writeLog("SQL DETAIL: $sqlDetail");

    if (!mysqli_query($conn, $sqlDetail)) {
      throw new Exception(mysqli_error($conn));
    }
  }

  /* =========================
     COMMIT
  ========================= */
  mysqli_commit($conn);
  writeLog('COMMIT SUCCESS');

  /* =========================
    AMBIL DATA HEADER
  ========================= */
  $h = mysqli_fetch_assoc(mysqli_query($conn,"
  SELECT t.*,
  IFNULL(c.nama_customer,'Umum') AS customer,
  IFNULL(c.nama_customer,'Umum') AS nama_customer,
  IFNULL(c.nope_customer,'-') AS nope_customer,
  u.nama AS nama_user,
  IFNULL(d.nama_designer,'No Designer') AS designer,
  tk.nama_toko,
  tk.alamat_toko,
  tk.telp_toko,
  tk.logo_toko
  FROM tb_transaksi t
  LEFT JOIN tb_customer c ON t.id_customer=c.id_customer
  LEFT JOIN tb_user u ON t.id_user=u.id_user
  LEFT JOIN tb_designer d ON t.id_designer=d.id_designer
  LEFT JOIN tb_toko tk ON t.id_toko=tk.id_toko
  WHERE t.id_transaksi='$id_transaksi'
  "));

  /* =========================
    AMBIL DATA DETAIL
  ========================= */
  $detail = [];
  $q = mysqli_query($conn,"
  SELECT td.*, jc.nama_jenis
  FROM tb_transaksi_detail td
  JOIN tb_jenis_cetakan jc 
    ON td.id_jenis_cetakan=jc.id_jenis_cetakan
  WHERE td.id_transaksi='$id_transaksi'
  ");

  while ($r = mysqli_fetch_assoc($q)) {
    $detail[] = $r;
  }

  /* =========================
    RESPONSE JSON
  ========================= */
  echo json_encode([
    'status' => true,
    'data' => [
      'header' => $h,
      'detail' => $detail
    ]
  ]);


} catch (Exception $e) {

  /* =========================
     ROLLBACK
  ========================= */
  mysqli_rollback($conn);
  writeLog('ROLLBACK ERROR: ' . $e->getMessage());

  echo json_encode([
    'status'  => false,
    'message' => $e->getMessage()
  ]);
}

writeLog('=== END TRANSAKSI ===');
