<?php

defined('BASEPATH') OR exit('No direct script access allowed');

class Admin_master extends CI_Controller {

    public function __construct() {
        parent::__construct();
        $this->load->model('Mmaster');
        $this->load->model('Mgrafik');
        $this->load->model('Mpetugas');
    }

    public function rupiah($angka) {
        $hasil_rupiah = number_format($angka, 0, '.', '.');
        return $hasil_rupiah;
    }

//----------------------------------------------------------------------- barang
    public function search_barang() {
        $toko = $this->input->post('toko');
        $nama_barang = $this->input->post('search_nama_barang');
        $filter_stock = $this->input->post('filter_stock');
        $baris = $this->input->post('baris');
        $list_barag = $this->Mmaster->search_barang($nama_barang, $filter_stock, $toko,$baris);
        if (count($list_barag) > 0) {
            $no = 1;
            foreach ($list_barag as $value) {
                $row = array();
                $row[] = '<tr onclick=form_edit_barang("' . $value->idbarang . '")>';
                $row[] = '<td>' . $no++ . '</td>';
                $row[] = '<td>' . $value->nama_barang . '</td>';
                if (($this->session->userdata['logged_in']['level']) == "Admin" || ($this->session->userdata['logged_in']['level']) == "Supervisor") {
                    $row[] = '<td>' . $this->rupiah($value->hargabeli) . '</td>';
                }
                $row[] = '<td>' . $this->rupiah($value->hecer1) . '</td>';
                $row[] = '<td>' . $this->rupiah($value->hecer2) . '</td>';
                $row[] = '<td>' . $this->rupiah($value->hgrosir1) . '</td>';
                $row[] = '<td>' . $this->rupiah($value->hgrosir2) . '</td>';
                $row[] = '<td>' . $this->rupiah($value->hgrosir3) . '</td>';
                $row[] = '<td>' . $value->produksi . '</td>';
                $row[] = '<td>' . $value->stock . '</td>';
                $row[] = '</tr>';
                $data[] = $row;
            }
            $sukses = 'ya';
        } else {
            $sukses = 'tidak';
            $data = '<tr><td colspan="10"><span class="text-danger" style="text-transform: uppercase"><b><u> ' . $nama_barang . ' </u></b></span> Tidak ditemukan silahkan gunakan kata pencarian lain atau tambahkan di barang baru</td></tr>';
        }
        $output = array(
            'sukses' => $sukses,
            'list_barang' => $data,
            'nama' => $this->input->post('barang')
        );
        echo json_encode($output);
    }

    public function simpan_barang() {
        if ($this->input->post('barang') == "") {
            $sukses = 'tidak';
            $pesan = 'Nama barang tidak boleh kosong';
        } else {
            $data_barang = array(
                'nama_barang' => $this->input->post('barang'),
                'hargabeli' => preg_replace('/[Rp. ]/', '', str_replace(chr(194) . chr(160), ' ', $this->input->post('hbeli'))),
                'hecer1' => preg_replace('/[Rp. ]/', '', str_replace(chr(194) . chr(160), ' ', $this->input->post('hecer1'))),
                'hecer2' => preg_replace('/[Rp. ]/', '', str_replace(chr(194) . chr(160), ' ', $this->input->post('hecer2'))),
                'hgrosir1' => preg_replace('/[Rp. ]/', '', str_replace(chr(194) . chr(160), ' ', $this->input->post('hgrosir1'))),
                'hgrosir2' => preg_replace('/[Rp. ]/', '', str_replace(chr(194) . chr(160), ' ', $this->input->post('hgrosir2'))),
                'hgrosir3' => preg_replace('/[Rp. ]/', '', str_replace(chr(194) . chr(160), ' ', $this->input->post('hgrosir3'))),
                'produksi' => $this->input->post('produksi')
            );
            $insert_get_lastid = $this->Mmaster->simpan_data_barang($data_barang);
            $data_stock = array(
                'idbarang' => $insert_get_lastid,
                'idtoko' => $this->session->userdata['logged_in']['toko'],
                'stock' => $this->input->post('stock'),
            );
            $this->Mmaster->simpan_data_barang_stock($data_stock);
            $sukses = 'ya';
            $pesan = '<label >Data barang <span  style="color:green">"' . $this->input->post('barang') . '"</span> berhasil di tambahkan !</label>';
        }
        $output = array(
            'sukses' => $sukses,
            'pesan' => $pesan,
            'nama' => $this->input->post('barang')
        );
        echo json_encode($output);
    }

    public function update_barang() {
        if ($this->input->post('barang') == "") {
            $sukses = 'tidak';
            $pesan = 'Nama barang tidak boleh kosong';
        } else {
            $id = $this->input->post('kode_barang');
            $id_stock=  $this->input->post('kode_stock');
            $data_barang = array(
                'nama_barang' => $this->input->post('barang'),
                'hargabeli' => preg_replace('/[Rp. ]/', '', str_replace(chr(194) . chr(160), ' ', $this->input->post('hbeli'))),
                'hecer1' => preg_replace('/[Rp. ]/', '', str_replace(chr(194) . chr(160), ' ', $this->input->post('hecer1'))),
                'hecer2' => preg_replace('/[Rp. ]/', '', str_replace(chr(194) . chr(160), ' ', $this->input->post('hecer2'))),
                'hgrosir1' => preg_replace('/[Rp. ]/', '', str_replace(chr(194) . chr(160), ' ', $this->input->post('hgrosir1'))),
                'hgrosir2' => preg_replace('/[Rp. ]/', '', str_replace(chr(194) . chr(160), ' ', $this->input->post('hgrosir2'))),
                'hgrosir3' => preg_replace('/[Rp. ]/', '', str_replace(chr(194) . chr(160), ' ', $this->input->post('hgrosir3'))),
                'produksi' => $this->input->post('produksi')
            );
            $this->Mmaster->update_data_barang(array('idbarang' => $id), $data_barang);
            $data_stock = array(
                'stock' => $this->input->post('stock'),
            );
            $this->Mmaster->update_data_stock_barang(array('idstock' => $id_stock), $data_stock);
            $sukses = 'ya';
            $pesan = '<label >Data barang <span  style="color:red">"' . $this->input->post('barang') . '"</span> berhasil di perbaharui !</label>';
        }
        $output = array(
            'sukses' => $sukses,
            'pesan' => $pesan
        );
        echo json_encode($output);
    }

    public function autobarang() {
        $cari = $this->input->post('cari');
        $q = $this->Mmaster->autobarang($cari,$this->session->userdata['logged_in']['toko']);
        if ($q->num_rows() > 0) {
            foreach ($q->result_array() as $k) {
                $data[] = [
                    'sukses' => true,
                    'nama_barang' => $k['nama_barang'],
                    'id_barang' => $k['idbarang'],
                    'produksi' => $k['produksi'],
                    'stock' => $k['stock'],
                    'hargabeli' => $k['hargabeli'],
                    'hgrosir1' => $k['hgrosir1'],
                    'hgrosir2' => $k['hgrosir2'],
                    'hgrosir3' => $k['hgrosir3'],
                    'hecer1' => $k['hecer1'],
                    'hecer2' => $k['hecer2']
                ];
            }
        } else {
            $data[] = [
                'sukses' => false,
                'nama_barang' => '<span style="color:red">' . $cari . '</span> tidak ditemukan',
                'stock' => '-'
            ];
        }

        echo json_encode($data);
    }

    public function autobarang_pindahstock() {
        $cari = $this->input->post('cari');
        $daritoko = $this->input->post('daritoko');
        $q = $this->Mmaster->autobarang_pindahstock($cari, $daritoko);
        if ($q->num_rows() > 0) {
            foreach ($q->result_array() as $k) {
                $data[] = [
                    'sukses' => true,
                    'nama_barang' => $k['nama_barang'],
                    'id_barang' => $k['idbarang'],
                    'stock' => $k['stock'],
                ];
            }
        } else {
            $data[] = [
                'sukses' => false,
                'nama_barang' => '<span style="color:red">' . $cari . '</span> tidak ditemukan',
                'stock' => '-'
            ];
        }

        echo json_encode($data);
    }

//--------------------------------------------------------------------- customer
    public function search_customer() {
        $search_customer_by = $this->input->post('search_customer_by');
        $filter_nama = $this->input->post('fn');
        $filter_alamat = $this->input->post('fa');
        $fillter_wilayah = $this->input->post('fw');
        $baris = $this->input->post('baris');
        $list_customer = $this->Mmaster->search_customer($search_customer_by, $filter_nama, $filter_alamat, $fillter_wilayah,$baris);
        if (count($list_customer) > 0) {
            $no = 1;
            foreach ($list_customer as $value) {
                $row = array();
                $row[] = '<tr onclick=form_edit_customer("' . $value->idcustomer . '")>';
                $row[] = '<td>' . $no++ . '</td>';
                $row[] = '<td>' . $value->nama_customer . '</td>';
                $row[] = '<td>' . $value->alamat_customer . '</td>';
                $row[] = '<td>' . $value->wilayah_customer . '</td>';
                $row[] = '<td>' . $value->hp_customer . '</td>';
                $row[] = '<td>' . $value->status_customer . '</td>';
                $row[] = '<td>' . $value->nama_marketing . '</td>';
                $row[] = '</tr>';
                $data[] = $row;
            }
            $sukses = 'ya';
        } else {
            $sukses = 'tidak';
            $data = '<tr><td colspan="9"><span class="text-danger" style="text-transform: uppercase"><b><u> ' . $search_customer_by . ' </u></b></span> Tidak ditemukan silahkan gunakan kata pencarian lain !</td></tr>';
        }
        $output = array(
            'sukses' => $sukses,
            'list_customer' => $data
        );
        echo json_encode($output);
    }

    function simpan_customer() {
        if ($this->input->post('id_marketing') == "") {
            $sukses = 'tidak';
            $pesan = 'Nama marketing tidak boleh kosong';
            $error = 'marketing';
        } elseif ($this->input->post('customer') == "") {
            $sukses = 'tidak';
            $pesan = 'Nama customer tidak boleh kosong';
            $error = 'customer';
        } else {
            $data_customer = array(
                'nama_customer' => $this->input->post('customer'),
                'alamat_customer' => $this->input->post('alamat'),
                'wilayah_customer' => $this->input->post('wilayah'),
                'hp_customer' => $this->input->post('hp'),
                'status_customer' => $this->input->post('status'),
                'idmarketing' => $this->input->post('id_marketing'),
                'idtoko' => $this->session->userdata['logged_in']['toko']
            );
            $this->Mmaster->simpan_data_customer($data_customer);
            $sukses = 'ya';
            $pesan = '<label >Data customer <span  style="color:green">"' . $this->input->post('customer') . '"</span> berhasil di tambahkan !</label>';
            $error = FALSE;
        }
        $output = array(
            'sukses' => $sukses,
            'pesan' => $pesan,
            'nama' => $this->input->post('customer'),
            'error' => $error
        );
        echo json_encode($output);
    }

    public function update_customer() {
        if ($this->input->post('customer') == "") {
            $sukses = 'tidak';
            $pesan = 'Nama customer tidak boleh kosong';
        } else {
            $id = $this->input->post('id_customer');
            $data_customer = array(
                'nama_customer' => $this->input->post('customer'),
                'alamat_customer' => $this->input->post('alamat'),
                'wilayah_customer' => $this->input->post('wilayah'),
                'hp_customer' => $this->input->post('hp'),
                'status_customer' => $this->input->post('status'),
                'idmarketing' => $this->input->post('id_marketing')
            );
            $this->Mmaster->update_data_customer(array('idcustomer' => $id), $data_customer);
            $sukses = 'ya';
            $pesan = '<label >Data customer <span  style="color:red">"' . $this->input->post('customer') . '"</span> berhasil di perbaharui !</label>';
        }
        $output = array(
            'sukses' => $sukses,
            'pesan' => $pesan,
            'nama' => $this->input->post('customer')
        );
        echo json_encode($output);
    }

    public function autocustomer() {
        $q = $this->Mmaster->autocustomer();
        if ($q->num_rows() > 0) {
            foreach ($q->result_array() as $k) {
                $data[] = [
                    'nama' => $k['nama_customer'],
                    'idcustomer' => $k['idcustomer'],
                    'alamat' => $k['alamat_customer']
                ];
            }
        } else {
            $data[] = [
                'nama' => "Tidak ada",
                'alamat' => "",
                'hp' => ""
            ];
        }
        echo json_encode($data);
    }

    //--------------------------------------------------------------------- marketing
    public function search_marketing() {
        $search_marketing_by = $this->input->post('search_marketing_by');
        $filter_nama = $this->input->post('fn');
        $filter_alamat = $this->input->post('fa');
        $list_marketing = $this->Mmaster->search_marketing($search_marketing_by, $filter_nama, $filter_alamat);
        if (count($list_marketing) > 0) {
            $no = 1;
            foreach ($list_marketing as $value) {
                $row = array();
                $row[] = '<tr onclick=form_edit_marketing("' . $value->idmarketing . '")>';
                $row[] = '<td>' . $no++ . '</td>';
                $row[] = '<td>' . $value->nama_marketing . '</td>';
                $row[] = '<td>' . $value->alamat_marketing . '</td>';
                $row[] = '<td>' . $value->hp_marketing . '</td>';
                $row[] = '</tr>';
                $data[] = $row;
            }
            $sukses = 'ya';
        } else {
            $sukses = 'tidak';
            $data = '<tr><td colspan="9"><span class="text-danger" style="text-transform: uppercase"><b><u> ' . $search_marketing_by . ' </u></b></span> Tidak ditemukan silahkan gunakan kata pencarian lain !</td></tr>';
        }
        $output = array(
            'sukses' => $sukses,
            'list_marketing' => $data
        );
        echo json_encode($output);
    }

    function simpan_marketing() {
        if ($this->input->post('marketing') == "") {
            $sukses = 'tidak';
            $pesan = 'Nama marketing tidak boleh kosong';
        } else {
            $data_marketing = array(
                'nama_marketing' => $this->input->post('marketing'),
                'alamat_marketing' => $this->input->post('alamat'),
                'hp_marketing' => $this->input->post('hp')
            );
            $this->Mmaster->simpan_data_marketing($data_marketing);
            $sukses = 'ya';
            $pesan = '<label >Data marketing <span  style="color:green">"' . $this->input->post('marketing') . '"</span> berhasil di tambahkan !</label>';
        }
        $output = array(
            'sukses' => $sukses,
            'pesan' => $pesan,
            'nama' => $this->input->post('marketing')
        );
        echo json_encode($output);
    }

    public function update_marketing() {
        if ($this->input->post('marketing') == "") {
            $sukses = 'tidak';
            $pesan = 'Nama marketing tidak boleh kosong';
        } else {
            $id = $this->input->post('id_marketing');
            $data_marketing = array(
                'nama_marketing' => $this->input->post('marketing'),
                'alamat_marketing' => $this->input->post('alamat'),
                'hp_marketing' => $this->input->post('hp')
            );
            $this->Mmaster->update_data_marketing(array('idmarketing' => $id), $data_marketing);
            $sukses = 'ya';
            $pesan = '<label >Data marketing <span  style="color:red">"' . $this->input->post('marketing') . '"</span> berhasil di perbaharui !</label>';
        }
        $output = array(
            'sukses' => $sukses,
            'pesan' => $pesan,
            'nama' => $this->input->post('marketing')
        );
        echo json_encode($output);
    }

    public function automarketing() {
        $q = $this->Mmaster->automarketing();
        if ($q->num_rows() > 0) {
            foreach ($q->result_array() as $k) {
                $data[] = array(
                    'nama' => $k['nama_marketing'],
                    'id' => $k['idmarketing']
                );
            }
        } else {
            $data [] = array(
                'nama' => "Tidak ada",
                'id' => "",
            );
        }
        echo json_encode($data);
    }

    //----------------------------------------------------------------- suplayer
    public function search_suplayer() {
        $search_suplayer_by = $this->input->post('search_suplayer_by');
        $filter_nama = $this->input->post('fn');
        $filter_alamat = $this->input->post('fa');
        $list_suplayer = $this->Mmaster->search_suplayer($search_suplayer_by, $filter_nama, $filter_alamat);
        if (count($list_suplayer) > 0) {
            $no = 1;
            foreach ($list_suplayer as $value) {
                $row = array();
                $row[] = '<tr onclick=form_edit_suplayer("' . $value->idsuplayer . '")>';
                $row[] = '<td>' . $no++ . '</td>';
                $row[] = '<td>' . $value->nama_suplayer . '</td>';
                $row[] = '<td>' . $value->alamat_suplayer . '</td>';
                $row[] = '<td>' . $value->hp_suplayer . '</td>';
                $row[] = '</tr>';
                $data[] = $row;
            }
            $sukses = 'ya';
        } else {
            $sukses = 'tidak';
            $data = '<tr><td colspan="9"><span class="text-danger" style="text-transform: uppercase"><b><u> ' . $search_suplayer_by . ' </u></b></span> Tidak ditemukan silahkan gunakan kata pencarian lain !</td></tr>';
        }
        $output = array(
            'sukses' => $sukses,
            'list_suplayer' => $data
        );
        echo json_encode($output);
    }

    function simpan_suplayer() {
        if ($this->input->post('suplayer') == "") {
            $sukses = 'tidak';
            $pesan = 'Nama suplayer tidak boleh kosong';
        } else {
            $data_suplayer = array(
                'nama_suplayer' => $this->input->post('suplayer'),
                'alamat_suplayer' => $this->input->post('alamat'),
                'hp_suplayer' => $this->input->post('hp')
            );
            $this->Mmaster->simpan_data_suplayer($data_suplayer);
            $sukses = 'ya';
            $pesan = '<label >Data suplayer <span  style="color:green">"' . $this->input->post('suplayer') . '"</span> berhasil di tambahkan !</label>';
        }
        $output = array(
            'sukses' => $sukses,
            'pesan' => $pesan,
            'nama' => $this->input->post('suplayer')
        );
        echo json_encode($output);
    }

    public function update_suplayer() {
        if ($this->input->post('suplayer') == "") {
            $sukses = 'tidak';
            $pesan = 'Nama suplayer tidak boleh kosong';
        } else {
            $id = $this->input->post('id_suplayer');
            $data_suplayer = array(
                'nama_suplayer' => $this->input->post('suplayer'),
                'alamat_suplayer' => $this->input->post('alamat'),
                'hp_suplayer' => $this->input->post('hp')
            );
            $this->Mmaster->update_data_suplayer(array('idsuplayer' => $id), $data_suplayer);
            $sukses = 'ya';
            $pesan = '<label >Data suplayer <span  style="color:red">"' . $this->input->post('suplayer') . '"</span> berhasil di perbaharui !</label>';
        }
        $output = array(
            'sukses' => $sukses,
            'pesan' => $pesan,
            'nama' => $this->input->post('suplayer')
        );
        echo json_encode($output);
    }

    public function autosuplayer() {
        $q = $this->Mmaster->autosuplayer();
        if ($q->num_rows() > 0) {
            foreach ($q->result_array() as $k) {
                $data[] = [
                    'nama' => $k['nama_suplayer'],
                    'idsuplayer' => $k['idsuplayer'],
                    'hp_suplayer' => $k['hp_suplayer'],
                    'alamat_suplayer' => $k['alamat_suplayer']
                ];
            }
        } else {
            $data[] = [
                'nama' => "Tidak ada",
                'idsuplayer' => "",
                'hp_suplayer' => "",
                'alamat_suplayer' => ""
            ];
        }
        echo json_encode($data);
    }

    //----------------------------------------------------------------- petugas
    public function search_petugas() {
        $search_petugas_by = $this->input->post('search_petugas_by');
        $list_petugas = $this->Mmaster->search_petugas($search_petugas_by);
        if (count($list_petugas) > 0) {
            $jumlah_nota = $this->Mgrafik->progres_keaktifan_all();
            $no = 1;
            foreach ($list_petugas as $value) {
                $jumlah_nota_per_user = $this->Mgrafik->progres_keaktifan_per_user($value->iduser);
                $nama_toko = $this->Mmaster->search_idtoko($value->idtoko);
                $persen = ($jumlah_nota_per_user->jum_per_user / $jumlah_nota) * 100;
                if ($persen < 20) {
                    $warna = "red";
                } else if ($persen < 30) {
                    $warna = "warning";
                } else {
                    $warna = "success";
                }
                $row = array();
                $row[] = '<tr onclick=form_edit_petugas("' . $value->iduser . '")>';
                $row[] = '<td>' . $no++ . '</td>';

                $row[] = '<td>' . $nama_toko->nama . '</td>';
                $row[] = '<td>' . $value->nama . '</td>';
                $row[] = '<td>' . $value->alamat . '</td>';
                $row[] = '<td>' . $value->hp . '</td>';
                $row[] = '<td>' . $value->jabatan . '</td>';
                $row[] = '<td>' . $value->statususer . '</td>';
                $row[] = '<td>
                    <div class="progress progress-xs">
                  <div class="progress-bar bg-' . $warna . ' progress-bar-striped" role="progressbar"
                       aria-valuenow="60" aria-valuemin="0" aria-valuemax="100" style="width: ' . $persen . '%">
                  </div>
                </div>
                 <small>' . $jumlah_nota_per_user->jum_per_user . '/' . $jumlah_nota . ' Transaksi</small>
                        </td>';
                $row[] = '</tr>';
                $data[] = $row;
            }
            $sukses = 'ya';
        } else {
            $sukses = 'tidak';
            $data = '<tr><td colspan="8"><span class="text-danger" style="text-transform: uppercase"><b><u> ' . $search_petugas_by . ' </u></b></span> Tidak ditemukan silahkan gunakan kata pencarian lain !</td></tr>';
        }
        $output = array(
            'sukses' => $sukses,
            'list_petugas' => $data
        );
        echo json_encode($output);
    }

    function simpan_petugas() {
        $username = $this->input->post('uname');
        $pass = $this->input->post('password');
        $result = $this->Mpetugas->read_user_information($username);
        if ($this->input->post('petugas') == "") {
            $sukses = 'tidak';
            $pesan = 'Nama lengkap petugas tidak boleh kosong';
        } elseif ($username == "" || $pass = "") {
            $sukses = 'tidak';
            $pesan = 'Maaf username atau password petugas tidak boleh kosong';
        } elseif ($result != false) {
            $sukses = 'tidak';
            $pesan = 'Maaf username telah terdaftar, silahkan gunakan kata lain';
        } else {
            $data_petugas = array(
                'nama' => $this->input->post('petugas'),
                'alamat' => $this->input->post('alamat'),
                'hp' => $this->input->post('hp'),
                'username' => $username,
                'password' => $this->input->post('password'),
                'statususer' => 'aktif',
                'jabatan' => $this->input->post('akses'),
                'idtoko' => $this->input->post('pilihtoko')
            );
            $this->Mmaster->simpan_data_petugas($data_petugas);
            $sukses = 'ya';
            $pesan = '<label >Data petugas <span  style="color:green">"' . $this->input->post('petugas') . '"</span> berhasil di tambahkan !</label>';
        }
        $output = array(
            'sukses' => $sukses,
            'pesan' => $pesan,
            'nama' => $this->input->post('petugas')
        );
        echo json_encode($output);
    }

    public function update_petugas() {
        $username = $this->input->post('uname');
        $pass = $this->input->post('pass');
        if ($username == "") {
            $u = $this->input->post('uname_lama');
        } else {
            $u = $this->input->post('uname');
        }
        if ($pass == "") {
            $p = $this->input->post('pass_lama');
        } else {
            $p = $this->input->post('pass');
        }

        $result = $this->Mpetugas->read_user_information($username);
        if ($this->input->post('petugas') == "") {
            $sukses = 'tidak';
            $pesan = 'Nama lengkap petugas tidak boleh kosong';
        } elseif ($result != false) {
            $sukses = 'tidak';
            $pesan = 'Maaf username telah terdaftar, silahkan gunakan kata lain';
        } else {
            $id = $this->input->post('id_petugas');
            $data_petugas = array(
                'nama' => $this->input->post('petugas'),
                'alamat' => $this->input->post('alamat'),
                'hp' => $this->input->post('hp'),
                'statususer' => $this->input->post('status'),
                'username' => $u,
                'password' => $p,
                'jabatan' => $this->input->post('akses')
            );
            $this->Mmaster->update_data_petugas(array('iduser' => $id), $data_petugas);
            $sukses = 'ya';
            $pesan = '<label >Data petugas <span  style="color:red">"' . $this->input->post('petugas') . '"</span> berhasil di perbaharui !</label>';
        }
        $output = array(
            'sukses' => $sukses,
            'pesan' => $pesan,
            'nama' => $this->input->post('petugas')
        );
        echo json_encode($output);
    }
    //----------------------------------------------------------------- toko
    public function search_toko() {
        $search_toko_by = $this->input->post('search_toko_by');
        $list_toko = $this->Mmaster->search_toko($search_toko_by);
        if (count($list_toko) > 0) {
            $no = 1;
            foreach ($list_toko as $value) {
                $row = array();
                $row[] = '<tr onclick=form_edit_toko("' . $value->idtoko . '")>';
                $row[] = '<td>' . $no++ . '</td>';
                $row[] = '<td>' . $value->nama . '</td>';
                $row[] = '<td>' . $value->alamat_toko . '</td>';
                $data[] = $row;
            }
            $sukses = 'ya';
        } else {
            $sukses = 'tidak';
            $data = '<tr><td colspan="8"><span class="text-danger" style="text-transform: uppercase"><b><u> ' . $search_toko_by . ' </u></b></span> Tidak ditemukan silahkan gunakan kata pencarian lain !</td></tr>';
        }
        $output = array(
            'sukses' => $sukses,
            'list_toko' => $data
        );
        echo json_encode($output);
    }

    function simpan_toko() {
        if ($this->input->post('toko') == "") {
            $sukses = 'tidak';
            $pesan = 'Nama toko tidak boleh kosong';
        } else {
            $data_toko = array(
                'nama' => $this->input->post('toko'),
                'alamat_toko' => $this->input->post('alamat')
            );
            $this->Mmaster->simpan_data_toko($data_toko);
            $sukses = 'ya';
            $pesan = '<label >Data toko <span  style="color:green">"' . $this->input->post('toko') . '"</span> berhasil di tambahkan !</label>';
        }
        $output = array(
            'sukses' => $sukses,
            'pesan' => $pesan,
            'nama' => $this->input->post('toko')
        );
        echo json_encode($output);
    }

    public function update_toko() {
        if ($this->input->post('toko') == "") {
            $sukses = 'tidak';
            $pesan = 'Nama lengkap toko tidak boleh kosong';
        }  else {
            $id = $this->input->post('id_toko');
            $data_toko = array(
                'nama' => $this->input->post('toko'),
                'alamat_toko' => $this->input->post('alamat')
            );
            $this->Mmaster->update_data_toko(array('idtoko' => $id), $data_toko);
            $sukses = 'ya';
            $pesan = '<label >Data toko <span  style="color:red">"' . $this->input->post('toko') . '"</span> berhasil di perbaharui !</label>';
        }
        $output = array(
            'sukses' => $sukses,
            'pesan' => $pesan,
            'nama' => $this->input->post('toko')
        );
        echo json_encode($output);
    }
    
    public function search_histori_barang() {
        $id_barang= $this->input->post('id');
//        $filter_stock = $this->input->post('filter_stock');
//        $baris = $this->input->post('baris');
        $list_data = $this->Mmaster->search_histori_barang($id_barang);
        if (count($list_data) > 0) {
            $no = 1;
            foreach ($list_data as $value) {
                 if ($value->idcustomer == 0 || $value->idcustomer == "") {
                    $nm_c = 'customer ecer (-)';
                } else {
                    $nm_c = $value->nama_customer;
                }
                $row = array();
                $row[] = '<tr>';
                $row[] = '<td>' . $no++ . '</td>';
                $row[] = '<td>' . $value->notatransaksi_penjualan_customer . '</td>';
                $row[] = '<td>' . $value->tanggal . '</td>';
                $row[] = '<td>' . $value->jenis_harga_penjualan . '</td>';
                $row[] = '<td>' . $nm_c . '</td>';
                $row[] = '<td>' . $value->nama_marketing . '</td>';
                $row[] = '<td>' . $value->nama . '</td>';
                $row[] = '<td>' . $value->jumlah . '</td>';
                $row[] = '</tr>';
                $data[] = $row;
            }
            $sukses = 'ya';
        } else {
            $sukses = 'tidak';
            $data = '<tr><td colspan="8">Data tidak ditemukan </td></tr>';
        }
        $output = array(
            'sukses' => $sukses,
            'list_barang' => $data,
        );
        echo json_encode($output);
    }

}
