<?php

defined('BASEPATH') OR exit('No direct script access allowed');

class Admin_penjualan extends CI_Controller {

    public function __construct() {
        parent::__construct();
        $this->load->model('Mgrafik');
        $this->load->model('Mmaster');
        $this->load->model('Mpenjualan');
    }

     public function coba() {
        if ($this->input->post('tanggal_pengiriman') == "" || empty($this->input->post('tanggal_pengiriman'))) {
            $tanggal_pengiriman = '0000-00-00';
        } else {
            $tgl_p = explode('/', $this->input->post('tanggal_pengiriman'));
            $tanggal_pengiriman = $tgl_p[2] . '-' . $tgl_p[1] . '-' . $tgl_p[0];
        }
        $output = array(
            'status' => TRUE,
            'nota' => $this->input->post('nota'),
            'jenispenjualan' => $this->input->post('ecer_grosir'),
            'pesan' => $tanggal_pengiriman
        );

        echo json_encode($output);
    }

    public function aksi_simpan_penjualan() {
        $jumbrg = count($this->input->post('barang[]'));
        if ($this->input->post('id_marketing') == "" || empty($this->input->post('id_marketing')) || empty($this->input->post('marketing'))){
            $output = array(
                'status' => FALSE,
                'eror' => 'marketing',
                'pesan' => 'Silahkan pilih marketing'
            );
        } elseif ($this->input->post('id_customer') == "" && $this->input->post('ecer_grosir') == 'grosir') {
            $output = array(
                'status' => FALSE,
                'eror' => 'customer',
                'pesan' => 'Silahkan pilih customer'
            );
        } elseif ($this->input->post('barang[0]') == "") { // perlu diperbaharui karena jika databarang 1 di hapus maka tidak bosa di simpan
            $output = array(
                'status' => FALSE,
                'eror' => 'barang',
                'pesan' => 'Tidak ada barang yang dipilih, Silahkan pilih barang'
            );
        } elseif ($jumbrg > 0) {
            $totalbelanja = str_replace(chr(194) . chr(160), ' ', $this->input->post('total_belanja'));
            if ($this->input->post('ongkir') == "" || empty($this->input->post('ongkir'))) {
                $ongkir = 0;
            } else {
                $ongkir = str_replace(chr(194) . chr(160), ' ', $this->input->post('ongkir'));
            }
            if ($this->input->post('bayar') == "" || empty($this->input->post('bayar'))) {
                $bayar = 0;
            } else {
                $bayar = str_replace(chr(194) . chr(160), ' ', $this->input->post('bayar'));
            }
            $sisa = preg_replace('/[Rp. ]/', '', str_replace(chr(194) . chr(160), ' ', $this->input->post('sisa')));
            if ($sisa < 0 || $bayar == 0) {
                $statuslunas = "utang";
            } else {
                $statuslunas = "lunas";
            }
            if ($this->input->post('pengiriman') == "") {
                $viapengiriman = '-';
            } else {
                $viapengiriman = $this->input->post('pengiriman');
            }
            if ($this->input->post('tanggal_pengiriman') == "" || empty($this->input->post('tanggal_pengiriman'))) {
                $tanggal_pengiriman = '0000-00-00';
            } else {
                $tgl_p = explode('/', $this->input->post('tanggal_pengiriman'));
                $tanggal_pengiriman = $tgl_p[2] . '-' . $tgl_p[1] . '-' . $tgl_p[0];
            }
            $output_transaksi_penjualan = array(//start to save tbtransaksi_penjualan
                'notatransaksi_penjualan_customer' => $this->input->post('nota'), // nota baru
                'jenis_harga_penjualan' => $this->input->post('ecer_grosir'),
                'tanggal' => date('Y-m-d H:i:s a'),
                'ongkir' => preg_replace('/[Rp. ]/', '', $ongkir),
                'totalbayar' => preg_replace('/[Rp. ]/', '', $totalbelanja) - preg_replace('/[Rp. ]/', '', $ongkir), //total yang harus dibayar tanpa ongkir
                'bayar' => preg_replace('/[Rp. ]/', '', $bayar),
                'status_lunas' => $statuslunas,
                'status_pending' => $this->input->post('pendingYT'),
                'tanggal_pengiriman' => $tanggal_pengiriman,
                'via_pengiriman' => $viapengiriman,
                'idcustomer' => $this->input->post('id_customer'),
                'iduser' => $this->session->userdata['logged_in']['idptgs'],
                'idtoko' => $this->session->userdata['logged_in']['toko'],
                'idmarketing' => $this->input->post('id_marketing')
            );
            $this->Mpenjualan->simpan_transaksi_penjualan_customer($output_transaksi_penjualan);
//          start to save tbdetail_penjualan
            for ($i = 0; $i < $jumbrg; $i++) {
                if (trim($this->input->post('barang[' . $i . ']') != '')) {
                    $idb = trim($this->input->post('idb[' . $i . ']'));
                    $harga = trim($this->input->post('harga[' . $i . ']'));
                    $jumlah = trim($this->input->post('jumlah[' . $i . ']'));
                    $beli = trim($this->input->post('beli[' . $i . ']'));
                    $produksi = trim($this->input->post('produksi[' . $i . ']'));
                    $Jumlah_Beli = $jumlah * $beli;
                    $total_produksi = $jumlah * $produksi;
                    $output_detail_transaksi_penjualan[] = array(
                        'notatransaksi_penjualan_customer' => $this->input->post('nota'),
                        'idbarang' => $idb,
                        'jumlah' => $jumlah,
                        'hargabeli' => $beli,
                        'hargajual' => $harga,
                        'produksi' => $produksi,
                        'laba' => ($jumlah * $harga) - ($total_produksi + $Jumlah_Beli)
                    );
                    $stockawal = $this->Mpenjualan->stock($idb);
                    $stockbaru[] = array(
                        'idbarang' => $idb,
                        'stock' => ($stockawal->stock) - $jumlah
                    );
                }
            }
            if ($this->input->post('pendingYT') == 't') {
                $this->Mpenjualan->simpan_detail_transaksi_penjualan_customer($output_detail_transaksi_penjualan);
                $this->Mpenjualan->update_stock_barang_ketika_simpan_transaksi($stockbaru,$this->session->userdata['logged_in']['toko']);
                $output = array(
                    'status' => TRUE,
                    'nota' => $this->input->post('nota'),
                    'jenispenjualan' => $this->input->post('ecer_grosir'),
                    'pesan' => 'Transaksi penjualan berhasil di SIMPAN'
                );
            } else {
                $this->Mpenjualan->simpan_detail_transaksi_penjualan_customer($output_detail_transaksi_penjualan);
                $output = array(
                    'status' => TRUE,
                    'nota' => $this->input->post('nota'),
                    'jenispenjualan' => $this->input->post('ecer_grosir'),
                    'pesan' => 'Transaksi penjualan berhasil di PENDING'
                );
            }
        }
        echo json_encode($output);
    }
     public function cG($nota) {
        $cek_data = $this->Mpenjualan->cek_nota_penjulan_customer($nota);
        $ecer_grosir = $cek_data->jenis_harga_penjualan;
        $data = array(
            'penjualan' => $this->Mpenjualan->nota_penjulan_customer($nota, $ecer_grosir),
            'detail_penjualan' => $this->Mpenjualan->detail_nota_penjulan_customer($nota)
        );
        $this->load->view('v-admin/cetak_grosir', $data);
    }

    public function cE($nota) {
        $cek_data = $this->Mpenjualan->cek_nota_penjulan_customer($nota);
        $ecer_grosir = $cek_data->jenis_harga_penjualan;
        $data = array(
            'penjualan' => $this->Mpenjualan->nota_penjulan_customer($nota, $ecer_grosir),
            'detail_penjualan' => $this->Mpenjualan->detail_nota_penjulan_customer($nota)
        );
        $this->load->view('v-admin/cetak_ecer', $data);
    }

}
