<?php

defined('BASEPATH') OR exit('No direct script access allowed');

class Mmaster extends CI_Model {

    public function __construct() {
        parent::__construct();
    }

    public function toko() {
        $this->db->from('tbtoko');
        $query = $this->db->get();
        return $query->result();
    }

    public function search_idtoko($param) {
        $this->db->where('idtoko', $param);
        $query = $this->db->get('tbtoko');
        return $query->row();
    }

//----------------------------------------------------------------------- barang
    public function search_barang($nama_barang, $filter_stock, $toko, $baris) {
        $this->db->join('tbstock', 'tbstock.idbarang=tbbarang.idbarang');
        if (isset($nama_barang) && $filter_stock == "true") {
            $this->db->like('nama_barang', $nama_barang);
            $this->db->order_by('stock', 'ASC');
        } else if ($nama_barang == " " && $filter_stock == "true") {
            $this->db->order_by('stock', 'ASC');
        } else {
            $this->db->like('nama_barang', $nama_barang);
        }
        if ($baris != 'all') {
            $this->db->limit($baris);
        }
        $this->db->where('tbstock.idtoko', $toko);
        $this->db->from('tbbarang');
        $query = $this->db->get();
        return $query->result();
    }

    public function where_kode_barang($id) {
        $this->db->join('tbstock', 'tbstock.idbarang=tbbarang.idbarang');
        $this->db->where('tbbarang.idbarang', $id);
        $this->db->from('tbbarang');
        $query = $this->db->get();
        return $query->row();
    }

    public function simpan_data_barang($data) {
        $this->db->insert('tbbarang', $data);
        $last_id = $this->db->insert_id();
        return $last_id;
    }

    public function simpan_data_barang_stock($data) {
        return $this->db->insert('tbstock', $data);
    }

    public function update_data_barang($id, $data) {
        return $this->db->update('tbbarang', $data, $id);
    }

    public function update_data_stock_barang($id, $data) {
        return $this->db->update('tbstock', $data, $id);
    }

    public function databarang() {
        $query = $this->db->query('SELECT * FROM `tbbarang` JOIN `tbstock` ON `tbstock`.`idbarang`=`tbbarang`.`idbarang`');
        return $query->result();
    }

    function autobarang($nama, $daritoko) {
        $this->db->from('tbbarang');
        $this->db->join('tbstock', 'tbstock.idbarang = tbbarang.idbarang');
        $this->db->where('tbstock.idtoko', $daritoko);
        $this->db->order_by('nama_barang', 'ASC');
        $this->db->like('nama_barang', $nama);
        $this->db->limit(5);
        $query = $this->db->get();
        return $query;
    }

    function autobarang_pindahstock($nama, $daritoko) {
        $this->db->from('tbbarang');
        $this->db->join('tbstock', 'tbstock.idbarang = tbbarang.idbarang');
        $this->db->where('tbstock.idtoko', $daritoko);
        $this->db->order_by('nama_barang', 'ASC');
        $this->db->like('nama_barang', $nama);
        $this->db->limit(5);
        $query = $this->db->get();
        return $query;
    }

    //----------------------------------------------------------------- customer
    public function search_customer($search_customer_by, $filter_nama, $filter_alamat, $fillter_wilayah, $baris) {
        $this->db->join('tbmarketing', 'tbmarketing.idmarketing=tbcustomer.idmarketing');
        if ($filter_nama == "Nama") {
            $this->db->like('nama_customer', $search_customer_by);
            $this->db->order_by('nama_customer', 'ASC');
        } else if ($filter_alamat == "Alamat") {
            $this->db->like('alamat_customer', $search_customer_by);
            $this->db->order_by('alamat_customer', 'ASC');
        } else if ($fillter_wilayah == "Wilayah") {
            $this->db->like('wilayah_customer', $search_customer_by);
            $this->db->order_by('wilayah_customer', 'ASC');
        }
        if ($baris != 'all') {
            $this->db->limit($baris);
        }
        $this->db->from('tbcustomer');
        $query = $this->db->get();
        return $query->result();
    }

    public function where_kode_customer($id) {
        $this->db->join('tbmarketing', 'tbmarketing.idmarketing=tbcustomer.idmarketing');
        $this->db->where('idcustomer', $id);
        $this->db->from('tbcustomer');
        $query = $this->db->get();
        return $query->row();
    }

    public function update_data_customer($id, $data) {
        return $this->db->update('tbcustomer', $data, $id);
    }

    public function simpan_data_customer($data) {
        return $this->db->insert('tbcustomer', $data);
    }

    public function autocustomer() {
        $this->db->from('tbcustomer');
        $this->db->where('status_customer', 'aktif');
        $this->db->order_by('nama_customer', 'ASC');
        $query = $this->db->get();
        return $query;
    }

    //---------------------------------------------------------------- marketing
    public function search_marketing($search_marketing_by, $filter_nama, $filter_alamat) {
        if ($filter_nama == "Nama") {
            $this->db->like('nama_marketing', $search_marketing_by);
            $this->db->order_by('nama_marketing', 'ASC');
        } else if ($filter_alamat == "Alamat") {
            $this->db->like('alamat_marketing', $search_marketing_by);
            $this->db->order_by('alamat_marketing', 'ASC');
        }
        $this->db->limit(10);
        $this->db->from('tbmarketing');
        $query = $this->db->get();
        return $query->result();
    }

    public function where_kode_marketing($id) {
        $this->db->where('idmarketing', $id);
        $this->db->from('tbmarketing');
        $query = $this->db->get();
        return $query->row();
    }

    public function update_data_marketing($id, $data) {
        return $this->db->update('tbmarketing', $data, $id);
    }

    public function simpan_data_marketing($data) {
        return $this->db->insert('tbmarketing', $data);
    }

    public function automarketing() {
        $this->db->from('tbmarketing');
        $this->db->order_by('nama_marketing', 'ASC');
        $query = $this->db->get();
        return $query;
    }

    //----------------------------------------------------------------- suplayer
    public function search_suplayer($search_suplayer_by, $filter_nama, $filter_alamat) {
        if ($filter_nama == "Nama") {
            $this->db->like('nama_suplayer', $search_suplayer_by);
            $this->db->order_by('nama_suplayer', 'ASC');
        } else if ($filter_alamat == "Alamat") {
            $this->db->like('alamat_suplayer', $search_suplayer_by);
            $this->db->order_by('alamat_suplayer', 'ASC');
        }
        $this->db->limit(10);
        $this->db->from('tbsuplayer');
        $query = $this->db->get();
        return $query->result();
    }

    public function where_kode_suplayer($id) {
        $this->db->where('idsuplayer', $id);
        $this->db->from('tbsuplayer');
        $query = $this->db->get();
        return $query->row();
    }

    public function update_data_suplayer($id, $data) {
        return $this->db->update('tbsuplayer', $data, $id);
    }

    public function simpan_data_suplayer($data) {
        return $this->db->insert('tbsuplayer', $data);
    }

    public function autosuplayer() {
        $this->db->from('tbsuplayer');
        $this->db->order_by('nama_suplayer', 'ASC');
        $query = $this->db->get();
        return $query;
    }

//----------------------------------------------------------------- petugas
    public function search_petugas($search_petugas_by) {
        $this->db->like('nama', $search_petugas_by);
        $this->db->order_by('iduser', 'ASC');
        $this->db->from('tbuser');
        $query = $this->db->get();
        return $query->result();
    }

    public function where_kode_petugas($id) {
        $this->db->where('iduser', $id);
        $this->db->from('tbuser');
        $query = $this->db->get();
        return $query->row();
    }

    public function update_data_petugas($id, $data) {
        return $this->db->update('tbuser', $data, $id);
    }

    public function simpan_data_petugas($data) {
        return $this->db->insert('tbuser', $data);
    }

    public function where_kode_toko($id) {
        $this->db->where('idtoko', $id);
        $this->db->from('tbtoko');
        $query = $this->db->get();
        return $query->row();
    }

    //----------------------------------------------------------------- toko
    public function search_toko($search_toko_by) {
        $this->db->like('nama', $search_toko_by);
        $this->db->order_by('idtoko', 'ASC');
        $this->db->from('tbtoko');
        $query = $this->db->get();
        return $query->result();
    }

    public function update_data_toko($id, $data) {
        return $this->db->update('tbtoko', $data, $id);
    }

    public function simpan_data_toko($data) {
        return $this->db->insert('tbtoko', $data);
    }

    public function search_histori_barang($param) {

         $this->db->join('tbtransaksi_penjualan_customer', 'tbtransaksi_penjualan_customer.notatransaksi_penjualan_customer=tbdetailtransaksi_penjualan_customer.notatransaksi_penjualan_customer', 'left');
                $this->db->join('tbuser', 'tbuser.iduser=tbtransaksi_penjualan_customer.iduser', 'left');
        $this->db->join('tbcustomer', 'tbcustomer.idcustomer=tbtransaksi_penjualan_customer.idcustomer', 'left');
        $this->db->join('tbmarketing', 'tbmarketing.idmarketing=tbtransaksi_penjualan_customer.idmarketing', 'left');
         $this->db->order_by('tanggal', 'DESC');
//        $this->db->where('tanggal >=', $tglawal . ' 00:00:00');
//        $this->db->where('tanggal <=', $tglakhir . ' 23:59:59');
//        $this->db->where('`status_pending`', 't');
//        if ($baris != 'all') {
//            $this->db->limit($baris);
//        }
        $this->db->where('tbdetailtransaksi_penjualan_customer.idbarang', $param);
        $this->db->from('tbdetailtransaksi_penjualan_customer');
        $query = $this->db->get();
        return $query->result();
    }

}
