<?php

defined('BASEPATH') OR exit('No direct script access allowed');

use PhpOffice\PhpSpreadsheet\IOFactory;
use PhpOffice\PhpSpreadsheet\Spreadsheet;
use PhpOffice\PhpSpreadsheet\Reader\Csv;
use PhpOffice\PhpSpreadsheet\Reader\Xlsx;

class Admin_dashboard extends CI_Controller {

    public function __construct() {
        parent::__construct();
        $this->load->model('Mgrafik');
        $this->load->model('Mmaster');
        $this->load->model('Mpenjualan');
         $this->load->model('Mpembelian');
        $this->load->model('Mpending');
        $this->load->model('Mlaporan');
    }

    public function index() {
         if (isset($this->session->userdata['logged_in'])) {
            if (($this->session->userdata['logged_in']['level']) == "Kasir") {
                redirect(site_url('kasir'));
            } else {
                $id = $this->Mmaster->where_kode_petugas($this->session->userdata['logged_in']['idptgs']);
                $toko = $this->Mmaster->where_kode_toko($this->session->userdata['logged_in']['toko']);
                

                $output = array(
                    'nama_user' =>'',
                    'nama_toko' => ''
                );
                $this->load->view('admin_dashboard', $output);
            }
        } else {
            header("location:login");
        }
    }

    public function pemilik() {
        if (isset($this->session->userdata['logged_in'])) {
           if (($this->session->userdata['logged_in']['level']) == "Kasir") {
               redirect(site_url('kasir'));
           } else {
               $id = $this->Mmaster->where_kode_petugas($this->session->userdata['logged_in']['idptgs']);
               $toko = $this->Mmaster->where_kode_toko($this->session->userdata['logged_in']['toko']);
               $output = array(
                   'nama_user' => $id->nama,
                   'nama_toko' => $toko->nama
               );
               $this->load->view('admin_dashboard_pemilik', $output);
           }
       } else {
           header("location:login");
       }
   }
   public function admingudang() {
        if (isset($this->session->userdata['logged_in'])) {
            if (($this->session->userdata['logged_in']['level']) == "Kasir") {
                redirect(site_url('kasir'));
            } else {
                $id = $this->Mmaster->where_kode_petugas($this->session->userdata['logged_in']['idptgs']);
                $toko = $this->Mmaster->where_kode_toko($this->session->userdata['logged_in']['toko']);
                $output = array(
                    'nama_user' => $id->nama,
                    'nama_toko' => $toko->nama
                );
                $this->load->view('admin_dashboard_gudang', $output);
            }
        } else {
            header("location:login");
        }
    }

    public function kasir() {
        if (isset($this->session->userdata['logged_in'])) {
            
                $id = $this->Mmaster->where_kode_petugas($this->session->userdata['logged_in']['idptgs']);
                $toko = $this->Mmaster->where_kode_toko($this->session->userdata['logged_in']['toko']);
                $output = array(
                    'nama_user' => $id->nama,
                    'nama_toko' => $toko->nama
                );
                $this->load->view('admin_dashboard_kasir', $output);
            
        } else {
            header("location:login");
        }
    }
   

    public function rupiah($angka) {

        $hasil_rupiah = number_format($angka, 0, ',', '.');
        return $hasil_rupiah;
    }

//--------------------------------------------------------------------------home
    public function grafik_penjualan(){
        
        $thn = $this->input->post('thn');
        $loyalcus =$this->Mgrafik->cusloyal($thn);
        $total=0;
        $total_pengeluaran=0;
        $total_profit=0;
        $total_pengeluaran_pusat=0;
        $total_penjualankregenan=0;
        $total_pengeluarankregenan=0;
        $total_profitkregenan=0;
        $total_penjualankertosono=0;
        $total_pengeluarankertosono=0;
        $total_profitkertosono=0;
        $total_penjualangebangan=0;
        $total_pengeluarangebangan=0;
        $total_profitgebangan=0;
        
        foreach ($loyalcus as $jc) {
            $total=$total+$jc->Penjualan;
            $total_pengeluaran=$jc->total_pengeluaran;
            $total_profit=$jc->total_profit;
            $total_pengeluaran_pusat = $jc->pengeluaran_pusat;
            
            $total_penjualankregenan =$jc->total_penjualankregenan;
            $total_pengeluarankregenan=$jc->total_pengeluarankregenan;
            $total_profitkregenan=$jc->total_profitkregenan;
            
            $total_penjualankertosono=$jc->total_penjualankertosono;
            $total_pengeluarankertosono=$jc->total_pengeluarankertosono;
            $total_profitkertosono=$jc->total_profitkertosono;
            
            $total_penjualangebangan=$jc->total_penjualangebangan;
            $total_pengeluarangebangan=$jc->total_pengeluarangebangan;
            $total_profitgebangan=$jc->total_profitgebangan;
            
            
            $namacustomer[] = $jc->Bulan;
            $jmlcustomer[] = $jc->Penjualan;
            $rupiah[] = substr($jc->formatrupiah,0,10);
        }

        $dukungan = array(						
            "sukses" => 'yes',
            "label" =>$namacustomer,
            "value" =>$jmlcustomer,
            "total_penjualan" =>$this->rupiah($total),
            "total_pengeluaran" =>$this->rupiah($total_pengeluaran),
            "total_profit" => $this->rupiah($total_profit),
            "total_pengeluaran_pusat" => $this->rupiah($total_pengeluaran_pusat),
            "total_penjualankregenan" => $this->rupiah($total_penjualankregenan),
            "total_pengeluarankregenan" => $this->rupiah($total_pengeluarankregenan),
            "total_profitkregenan" => $this->rupiah($total_profitkregenan),
            "total_penjualankertosono" => $this->rupiah($total_penjualankertosono),
            "total_pengeluarankertosono" => $this->rupiah($total_pengeluarankertosono),
            "total_profitkertosono" => $this->rupiah($total_profitkertosono),
            "total_penjualangebangan" => $this->rupiah($total_penjualangebangan),
            "total_pengeluarangebangan" => $this->rupiah($total_pengeluarangebangan),
            "total_profitgebangan" => $this->rupiah($total_profitgebangan),
            "pesan" =>'sukses',
         );
        echo json_encode($dukungan);
    }
    public function home() {
        $tahun = $this->input->post('tahun');
        $datapenjualan = $this->Mgrafik->jmlpenjualan();
        foreach($datapenjualan as $dt);
        
        $datapengeluaran = $this->Mgrafik->jmlTOTALpengeluaran();
        foreach($datapengeluaran as $dp);
        
        $dataprovit= $this->Mgrafik->jmlTOTALprofit();
        foreach($dataprovit as $lb);
        
        $datamodal= $this->Mgrafik->jmlTOTALmodal();
        foreach($datamodal as $mb);
        
        $datapenjualankregenan = $this->Mgrafik->jmlpenjualankregenan();
        foreach($datapenjualankregenan as $dtkregenan);
        
        $datapengeluaran = $this->Mgrafik->jmlTOTALpengeluaran();
        foreach($datapengeluaran as $dp);
        
        $datapengeluaranpusat = $this->Mgrafik->jmlTOTALpengeluaranpusat();
        foreach($datapengeluaranpusat as $dppusat);
        
        $datapengeluarankregenan = $this->Mgrafik->jmlTOTALpengeluarankregenan();
        foreach($datapengeluarankregenan as $dpkregenan);
        
        $dataprovitkregenan= $this->Mgrafik->jmlTOTALprofitkregenan();
        foreach($dataprovitkregenan as $lbkregenan);
        
        $datamodalkregenan= $this->Mgrafik->jmlTOTALmodalkregenan();
        foreach($datamodalkregenan as $mbkregenan);
        
         $datapenjualankertosono = $this->Mgrafik->jmlpenjualankertosono();
        foreach($datapenjualankertosono as $dtkertosono);
        
         $datapengeluarankertosono = $this->Mgrafik->jmlTOTALpengeluarankertosono();
        foreach($datapengeluarankertosono as $dpkertosono);
        
        $dataprovitkertosono= $this->Mgrafik->jmlTOTALprofitkertosono();
        foreach($dataprovitkertosono as $lbkertosono);
        
        $datamodalkertosono= $this->Mgrafik->jmlTOTALmodalkertosono();
        foreach($datamodalkertosono as $mbkertosono);
        
        
         $datapenjualangebangan = $this->Mgrafik->jmlpenjualangebangan();
        foreach($datapenjualangebangan as $dtgebangan);
        
         $datapengeluarangebangan = $this->Mgrafik->jmlTOTALpengeluarangebangan();
        foreach($datapengeluarangebangan as $dpgebangan);
        
        $dataprovitgebangan= $this->Mgrafik->jmlTOTALprofitgebangan();
        foreach($dataprovitgebangan as $lbgebangan);
        
        $datamodalgebangan= $this->Mgrafik->jmlTOTALmodalgebangan();
        foreach($datamodalgebangan as $mbgebangan);
        
        
        $data = array(
            'jbarang' => $this->Mgrafik->jmlbarang(),
            'jsuplayer' => $this->Mgrafik->jmlsuplayer(),
            'jmarketing' => $this->Mgrafik->jmlmarketing(),
            'jcustomer' => $this->Mgrafik->jmlcustomer(),
            'jmlpenjualan' => $this->rupiah( $dt->totalbayar),
            'jmlpengeluaran' => $this->rupiah( $dp->nominal_pengeluaran),
            'jmlprovit' => $this->rupiah( $lb->laba),
            'jmlmodal' => $this->rupiah( $mb->modal_barang),
            'jmlpenjualankregenan' => $this->rupiah( $dtkregenan->totalbayar),
            'jmlpengeluarankregenan' => $this->rupiah( $dpkregenan->nominal_pengeluaran),
            'jmlprovitkregenan' => $this->rupiah( $lbkregenan->laba),
            'jmlmodalkregenan' => $this->rupiah( $mbkregenan->modal_barang),
            'jmlpenjualankertosono' => $this->rupiah( $dtkertosono->totalbayar),
            'jmlpengeluarankertosono' => $this->rupiah( $dpkertosono->nominal_pengeluaran),
            'jmlprovitkertosono' => $this->rupiah( $lbkertosono->laba),
            'jmlmodalkertosono' => $this->rupiah( $mbkertosono->modal_barang),
            'jmlpenjualangebangan' => $this->rupiah( $dtgebangan->totalbayar),
            'jmlpengeluarangebangan' => $this->rupiah( $dpgebangan->nominal_pengeluaran),
            'jmlprovitgebangan' => $this->rupiah( $lbgebangan->laba),
            'jmlmodalgebangan' => $this->rupiah( $mbgebangan->modal_barang),
            'jmlpenjualanpusat' => $this->rupiah( $dppusat->nominal_pengeluaran),
            'tahun' =>$tahun
            
            
            
            
            
            
            
            
        );
        $this->load->view('v-admin/home', $data);
    }
    //---------------------------------------------------------- master entri pengeluaran
     public function pengeluaran() {
        $output = array(
            'jpengeluaran' => $this->Mgrafik->jmlpengeluaran(),
            'toko'=>$this->Mmaster->toko()
        );
        $this->load->view('v-admin/pengeluaran', $output);
    }
    
    public function tambahmodal() {
        $output = array(
            'jmodal' => $this->Mgrafik->jmltambahmodal(),
            'toko'=>$this->Mmaster->toko()
        );
        $this->load->view('v-admin/tambahmodal', $output);
    }

    public function neraca() {
         $output = array(
            'toko'=>$this->Mmaster->toko()
        );
        $this->load->view('v-admin/neraca', $output);
    }
    public function form_tambah_pengeluaran() {
        // $output = array(
        //     'jenisbarang'=>$this->Mmaster->pilihjenisbarang()
        // );
        $this->load->view('v-admin/pengeluaran_tambah');

    }
    public function form_tambah_modal() {
        // $output = array(
        //     'jenisbarang'=>$this->Mmaster->pilihjenisbarang()
        // );
        $this->load->view('v-admin/modal_tambah');

    }
     public function form_edit_pengeluaran() {
        $id = $this->input->post('id');
        // $idtoko = $this->input->post('idtoko');
        $data_pengeluaran = $this->Mmaster->where_kode_pengeluaran($id);
        $output = array(
            'idpengeluaran' => $data_pengeluaran->idpengeluaran,
            'keterangan' => $data_pengeluaran->keterangan,
            'tanggal' => $data_pengeluaran->tanggal,
            'nominal_pengeluaran' => $this->rupiah($data_pengeluaran->nominal_pengeluaran)
        );
        $this->load->view('v-admin/pengeluaran_edit', $output);
    }

    // public function form_edit_pengeluarankasir() {
    //     $id = $this->input->post('id');
    //     // $idtoko = $this->input->post('idtoko');
    //     $data_pengeluaran = $this->Mmaster->where_kode_pengeluaran($id);
    //     $output = array(
    //         'idpengeluaran' => $data_pengeluaran->idpengeluaran,
    //         'keterangan' => $data_pengeluaran->keterangan,
    //         'tanggal' => $data_pengeluaran->tanggal,
    //         'nominal_pengeluaran' => $this->rupiah($data_pengeluaran->nominal_pengeluaran)
    //     );
    //     $this->load->view('v-kasir/pengeluaran_edit', $output);
    // }

//---------------------------------------------------------- master entri barang
    public function barang() {
        $output = array(
            'jbarang' => $this->Mgrafik->jmlbarang(),
            'toko'=>$this->Mmaster->toko()
        );
        $this->load->view('v-admin/barang', $output);
    }

    public function opname() {
        $output = array(
            'jbarang' => $this->Mgrafik->jmlbarang(),
            'toko'=>$this->Mmaster->toko()
        );
        $this->load->view('v-admin/barang_stock_opname', $output);
    }

    public function form_tambah_barang() {
        $output = array(
            'jenisbarang'=>$this->Mmaster->pilihjenisbarang()
        );
        $this->load->view('v-admin/barang_tambah', $output);

    }

    public function form_edit_barang() {
        $id = $this->input->post('id');
        $idtoko = $this->input->post('idtoko');
        $data_barang = $this->Mmaster->where_kode_barang($id,$idtoko);
        
        $data_barang_stock = $this->Mmaster->search_barang_stock($id,$idtoko);
        $output = array(
            'idbarang' => $data_barang->idbarang,
            'barcode' => $data_barang->barcode,
            'nama' => $data_barang->nama_barang,
            'hbeli' => $this->rupiah($data_barang->hargabeli),
            'hecer1' => $this->rupiah($data_barang->hecer1),
            'hecer2' => $this->rupiah($data_barang->hecer2),
            'hgrosir1' => $this->rupiah($data_barang->hgrosir1),
            'hgrosir2' => $this->rupiah($data_barang->hgrosir2),
            'hgrosir3' => $this->rupiah($data_barang->hgrosir3),
            'idtoko' => $data_barang->idtoko,
            'hpromo' => $this->rupiah($data_barang->hpromo),
            'tanggalpromo' => $data_barang->tanggalpromo,
            'isibarang' => $data_barang->isibarang,
            'statusbarang' => $data_barang->statusbarang,
            'stock' =>$data_barang_stock->stock
        );
        $this->load->view('v-admin/barang_edit', $output);
    }

    public function form_opname_barang() {
        $id = $this->input->post('id');
        $idtoko = $this->input->post('idtoko');
        $data_barang = $this->Mmaster->where_kode_barang($id,$idtoko);
        
        $data_barang_stock = $this->Mmaster->search_barang_stock($id,$idtoko);
        $output = array(
            'idbarang' => $data_barang->idbarang,
            'barcode' => $data_barang->barcode,
            'nama' => $data_barang->nama_barang,
            'hbeli' => $this->rupiah($data_barang->hargabeli),
            'hecer1' => $this->rupiah($data_barang->hecer1),
            'hecer2' => $this->rupiah($data_barang->hecer2),
            'hgrosir1' => $this->rupiah($data_barang->hgrosir1),
            'hgrosir2' => $this->rupiah($data_barang->hgrosir2),
            'hgrosir3' => $this->rupiah($data_barang->hgrosir3),
            'idtoko' => $data_barang->idtoko,
            'hpromo' => $this->rupiah($data_barang->hpromo),
            'tanggalpromo' => $data_barang->tanggalpromo,
            'isibarang' => $data_barang->isibarang,
            'statusbarang' => $data_barang->statusbarang,
            'stock' =>$data_barang_stock->stock
        );
        $this->load->view('v-admin/barang_opname', $output);
    }
    
    public function kategori_barang() {
        $output = array(
            'jkategori_barang' => $this->Mgrafik->jmlkategori_barang(),
        );
        $this->load->view('v-admin/kategori_barang', $output);
    }

    public function form_tambah_kategori_barang() {
       
        $this->load->view('v-admin/kategori_barang_tambah');

    }

    public function form_edit_kategori_barang() {
        $id = $this->input->post('id');
        $data_kategori_barang = $this->Mmaster->where_kategori_barang($id);
        $output = array(
            'idkategori_barang' => $data_kategori_barang->idjenisbarang,
            'kategori_barang' => $data_kategori_barang->nama_jenisbarang,
            'casbak_diskon' => $data_kategori_barang->casbak_diskon,
        );
        $this->load->view('v-admin/kategori_barang_edit', $output);
    }



     public function barang_historystock() {
        $id = $this->input->post('id');
        $idtoko = $this->input->post('idtoko');
        $output = array(
            'list_barangstock'=>$this->Mmaster->lihat_bstock($id,$idtoko)
        );
        $this->load->view('v-admin/barang_historystock', $output);
    }
    public function buku_hutang() {
        $id = $this->input->post('id');
        $output = array(
            'list_barangstock'=>$this->Mmaster->lihat_hutang($id)
        );
        $this->load->view('v-admin/hutang_historysuplayer', $output);
    }
    public function form_hapus_barang() {
       $id = $this->input->post('id');
       $this->Mmaster->hapus_data_barang($id);
            $sukses = 'ya';
            $pesan = '<label >Data barang <span  style="color:red">"' . $this->input->post('id') . '"</span> berhasil di Hapus !</label>';
        
        $output = array(
            'sukses' => $sukses,
            'pesan' => $pesan
        );
        echo json_encode($output);
    }

    public function form_hapus_pengeluaran() {
       $id = $this->input->post('id');
       
       $idp=array('idpengeluaran'=>$id);
       $this->db->delete('tbpengeluaran',$idp);
            $sukses = 'ya';
            $pesan = '<label >Data pengeluaran <span  style="color:red">"' . $this->input->post('id') . '"</span> berhasil di Hapus !</label>';
        
        $output = array(
            'sukses' => $sukses,
            'pesan' => $pesan
        );
        echo json_encode($output);
    }
    
    public function eksporthistory_nota_suplayer() {
        $nota =$this->input->post('nota');
        $detail_penjualan = $this->Mlaporan->detailhistory_nota_penjulan_suplayer($nota); 
        $no = 1;
        $reader = new \PhpOffice\PhpSpreadsheet\Reader\Xlsx();
        $spreadsheet = $reader->load('assets/format_data/Laporan_historysuplayer.xlsx');
     
        $sheet = $spreadsheet->getActiveSheet();
       
        $sheet = $spreadsheet->getActiveSheet();
        $baris_pertama = 6;
        
        foreach ($detail_penjualan as $value) {
                $nm_c = $value->nama_suplayer;
                $sheet->setCellValue('A'.$baris_pertama,date('d-m-Y H:i:s ', strtotime($value->tanggal))  );
                $sheet->setCellValue('B'.$baris_pertama,$value->notatransaksi_penjualan_suplayer);
                $sheet->setCellValue('C'.$baris_pertama, $nm_c ) ;
                $sheet->setCellValue('D'.$baris_pertama, $this->rupiah($value->bayar)  ) ;
                $sheet->setCellValue('E'.$baris_pertama, $this->rupiah($value->totalbayar) );
                $sheet->setCellValue('F'.$baris_pertama, $this->rupiah($value->sisa_piutang));
                $sheet->setCellValue('G'.$baris_pertama, $value->jenis_pembayaran);
                $baris_pertama++; 
        }
        $writer =  \PhpOffice\PhpSpreadsheet\IOFactory::createWriter($spreadsheet, "Xlsx");
        $writer->save('assets/format_data/Laporan_history_suplayer.xlsx');
        force_download(site_url('assets/format_data/Laporan_history_suplayer.xlsx'),NULL);

    }
    public function download_Laporan_history_suplayer($iddesa){		
	    force_download('assets/format_data/Laporan_history_suplayer.xlsx',NULL);
	}
    
    public function eksporthistory_nota_customer() {
        $nota =$this->input->post('nota');
        $detail_penjualan = $this->Mlaporan->detailhistory_nota_penjulan_customer($nota); 
        $no = 1;
        $reader = new \PhpOffice\PhpSpreadsheet\Reader\Xlsx();
        $spreadsheet = $reader->load('assets/format_data/Laporan_historycustomer.xlsx');
     
        $sheet = $spreadsheet->getActiveSheet();
       
        $sheet = $spreadsheet->getActiveSheet();
        $baris_pertama = 6;
        
        foreach ($detail_penjualan as $value) {
                $nm_c = $value->nama_customer;
                $sheet->setCellValue('A'.$baris_pertama,date('d-m-Y H:i:s ', strtotime($value->tanggal))  );
                $sheet->setCellValue('B'.$baris_pertama,$value->notatransaksi_penjualan_customer);
                $sheet->setCellValue('C'.$baris_pertama, $nm_c ) ;
                $sheet->setCellValue('D'.$baris_pertama, $this->rupiah($value->bayar)  ) ;
                $sheet->setCellValue('E'.$baris_pertama, $this->rupiah($value->totalbayar) );
                $sheet->setCellValue('F'.$baris_pertama, $this->rupiah($value->sisa_piutang));
                $sheet->setCellValue('G'.$baris_pertama, $value->jenis_pembayaran);
                $baris_pertama++; 
        }
        $writer =  \PhpOffice\PhpSpreadsheet\IOFactory::createWriter($spreadsheet, "Xlsx");
        $writer->save('assets/format_data/Laporan_history_customer.xlsx');
        force_download(site_url('assets/format_data/Laporan_history_customer.xlsx'),NULL);

    }
    public function download_Laporan_history_customer_piutang($iddesa){		
	    force_download('assets/format_data/Laporan_history_customer.xlsx',NULL);
	}
    function eksport_laporan_casback() {
        $search = $this->input->post('search_omset');
        $toko = $this->input->post('pilihtoko');
        $tgl = explode(' - ', $this->input->post('tgl'));
        $tgl_awal = explode('/', $tgl[0]);
        $tglawal = $tgl_awal[2] . '-' . $tgl_awal[0] . '-' . $tgl_awal[1];
        $tgl_akhir = explode('/', $tgl[1]);
        $tglakhir = $tgl_akhir[2] . '-' . $tgl_akhir[0] . '-' . $tgl_akhir[1];
        $baris = $this->input->post('baris');
        $reader = new \PhpOffice\PhpSpreadsheet\Reader\Xlsx();
        $spreadsheet = $reader->load('assets/format_data/Laporan_perputaran_kas.xlsx');
     
        $sheet = $spreadsheet->getActiveSheet();
       
        $sheet = $spreadsheet->getActiveSheet();
        $baris_pertama = 4;
        $list = $this->Mlaporan->laporan_casback($search, $tglawal, $tglakhir, $toko, $baris);
        if (count($list) > 0) {
            $no = 1;
            foreach ($list as $value) {
            
                $nm_c = $value->jenis;
                $sheet->setCellValue('A'.$baris_pertama,date('d-m-Y H:i:s ', strtotime($value->tanggal))  );
                $sheet->setCellValue('B'.$baris_pertama,$value->keterangan);
                $sheet->setCellValue('C'.$baris_pertama, $nm_c ) ;
                $sheet->setCellValue('D'.$baris_pertama, $value->nominal ) ;
                $baris_pertama++; 
            }
        }
        $writer =  \PhpOffice\PhpSpreadsheet\IOFactory::createWriter($spreadsheet, "Xlsx");
        $writer->save('assets/format_data/Laporan_perputaran_kas.xlsx');
        force_download(site_url('assets/format_data/Laporan_perputaran_kas.xlsx'),NULL);

    }
    public function download_Laporan_casback_customer($iddesa){		
	    force_download('assets/format_data/Laporan_perputaran_kas.xlsx',NULL);
	}

    public function eksport_piutang_suplayer1() {
        $search = $this->input->post('search_nm');
        $toko = $this->input->post('pilihtoko');
        $tgl = explode(' - ', $this->input->post('tgl'));
        $tgl_awal = explode('/', $tgl[0]);
        $tglawal = $tgl_awal[2] . '-' . $tgl_awal[0] . '-' . $tgl_awal[1];
        $tgl_akhir = explode('/', $tgl[1]);
        $tglakhir = $tgl_akhir[2] . '-' . $tgl_akhir[0] . '-' . $tgl_akhir[1];

        $reader = new \PhpOffice\PhpSpreadsheet\Reader\Xlsx();
        $spreadsheet = $reader->load('assets/format_data/Laporan_piutangs.xlsx');
     
        $sheet = $spreadsheet->getActiveSheet();
       
        $sheet = $spreadsheet->getActiveSheet();
        $baris_pertama = 5;
        
        $list = $this->Mlaporan->laporan_hutang_suplayer($search, $tglawal, $tglakhir, $toko);
        $filter = $this->input->post('filter');
        if (count($list) > 0) {
            $no = 1;
            foreach ($list as $value) {
                $row = array();
                if($filter=='semua'){
                    
                    $nm_c = $value->nama_suplayer;
                    $sheet->setCellValue('A'.$baris_pertama,$value->tgl_jatuh_tempo );
                    $sheet->setCellValue('B'.$baris_pertama,$value->tanggal);
                    $sheet->setCellValue('C'.$baris_pertama, $value->notatransaksi_kulakan) ;
                    $sheet->setCellValue('D'.$baris_pertama, $value->nota_faktur) ;
                    $sheet->setCellValue('E'.$baris_pertama, $nm_c) ;
                    $sheet->setCellValue('F'.$baris_pertama, $value->totalbayar-$value->bayar );
                    $sheet->setCellValue('G'.$baris_pertama, $value->status_lunas);
                    $baris_pertama++; 
                    
                }else if($filter=='lunas'){
                    if($value->status_lunas=='lunas'){
                        $nm_c = $value->nama_suplayer;
                        $sheet->setCellValue('A'.$baris_pertama,$value->tgl_jatuh_tempo );
                        $sheet->setCellValue('B'.$baris_pertama,$value->tanggal);
                        $sheet->setCellValue('C'.$baris_pertama, $value->notatransaksi_kulakan) ;
                        $sheet->setCellValue('D'.$baris_pertama, $value->nota_faktur) ;
                        $sheet->setCellValue('E'.$baris_pertama, $nm_c) ;
                        $sheet->setCellValue('F'.$baris_pertama, $value->totalbayar-$value->bayar );
                        $sheet->setCellValue('G'.$baris_pertama, $value->status_lunas);
                        $baris_pertama++; 
                    }
                }else if($filter=='utang'){
                    if($value->status_lunas=='utang'){

                        $nm_c = $value->nama_suplayer;
                        $sheet->setCellValue('A'.$baris_pertama,$value->tgl_jatuh_tempo );
                        $sheet->setCellValue('B'.$baris_pertama,$value->tanggal);
                        $sheet->setCellValue('C'.$baris_pertama, $value->notatransaksi_kulakan) ;
                        $sheet->setCellValue('D'.$baris_pertama, $value->nota_faktur) ;
                        $sheet->setCellValue('E'.$baris_pertama, $nm_c) ;
                        $sheet->setCellValue('F'.$baris_pertama, $value->totalbayar-$value->bayar );
                        $sheet->setCellValue('G'.$baris_pertama, $value->status_lunas);
                        $baris_pertama++; 
                    }

                }
            }
              
   
        } 
        $writer =  \PhpOffice\PhpSpreadsheet\IOFactory::createWriter($spreadsheet, "Xlsx");
        $writer->save('assets/format_data/Laporan_piutang_suplayer.xlsx');
        force_download(site_url('assets/format_data/Laporan_piutang_suplayer.xlsx'),NULL);
    }
    public function download_Laporan_piutang_suplayer($iddesa){		
	    force_download('assets/format_data/Laporan_piutang_suplayer.xlsx',NULL);
	}
    function export_laporan_retur_suplayer() {
        $search = $this->input->post('search_block_stock');
        $toko = $this->input->post('pilihtoko');
        $tgl = explode(' - ', $this->input->post('tgl'));
        $tgl_awal = explode('/', $tgl[0]);
        $tglawal = $tgl_awal[2] . '-' . $tgl_awal[0] . '-' . $tgl_awal[1];
        $tgl_akhir = explode('/', $tgl[1]);
        $tglakhir = $tgl_akhir[2] . '-' . $tgl_akhir[0] . '-' . $tgl_akhir[1];
        $baris = $this->input->post('baris');

        $reader = new \PhpOffice\PhpSpreadsheet\Reader\Xlsx();
        $spreadsheet = $reader->load('assets/format_data/Laporan_returcustomer.xlsx');
     
        $sheet = $spreadsheet->getActiveSheet();
       
        $sheet = $spreadsheet->getActiveSheet();
        $baris_pertama = 5;
        $sheet->setCellValue('A2','LAPORAN RETUR BARANG SUPLAYER' );
        $list = $this->Mlaporan->laporan_retur_suplayer($search, $tglawal, $tglakhir, $toko, $baris);
            foreach ($list as $value) {
                $sheet->setCellValue('A'.$baris_pertama,$value->tanggal );
                $sheet->setCellValue('B'.$baris_pertama,$value->notasuplayer);
                $sheet->setCellValue('C'.$baris_pertama, $value->nama_barang) ;
                $sheet->setCellValue('D'.$baris_pertama, $value->harga_jual) ;
                $sheet->setCellValue('E'.$baris_pertama, $value->jumlah );
                $sheet->setCellValue('F'.$baris_pertama, $value->total_retur);
                $baris_pertama++; 
                
            }
            $writer =  \PhpOffice\PhpSpreadsheet\IOFactory::createWriter($spreadsheet, "Xlsx");
            $writer->save('assets/format_data/Laporan_retur_barang.xlsx');
            force_download(site_url('assets/format_data/Laporan_retur_barang.xlsx'),NULL);
        
    }
    function export_laporan_retur_customer() {
        $search = $this->input->post('search_block_stock');
        $toko = $this->input->post('pilihtoko');
        $tgl = explode(' - ', $this->input->post('tgl'));
        $tgl_awal = explode('/', $tgl[0]);
        $tglawal = $tgl_awal[2] . '-' . $tgl_awal[0] . '-' . $tgl_awal[1];
        $tgl_akhir = explode('/', $tgl[1]);
        $tglakhir = $tgl_akhir[2] . '-' . $tgl_akhir[0] . '-' . $tgl_akhir[1];
        $baris = $this->input->post('baris');

        $reader = new \PhpOffice\PhpSpreadsheet\Reader\Xlsx();
        $spreadsheet = $reader->load('assets/format_data/Laporan_returcustomer.xlsx');
     
        $sheet = $spreadsheet->getActiveSheet();
       
        $sheet = $spreadsheet->getActiveSheet();
        $baris_pertama = 5;

        $list = $this->Mlaporan->laporan_retur_customer($search, $tglawal, $tglakhir, $toko, $baris);
            foreach ($list as $value) {
                $sheet->setCellValue('A'.$baris_pertama,$value->tanggal );
                $sheet->setCellValue('B'.$baris_pertama,$value->notacustomer);
                $sheet->setCellValue('C'.$baris_pertama, $value->nama_barang) ;
                $sheet->setCellValue('D'.$baris_pertama, $value->harga_jual) ;
                $sheet->setCellValue('E'.$baris_pertama, $value->jumlah );
                $sheet->setCellValue('F'.$baris_pertama, $value->total_retur);
                $baris_pertama++; 
                
            }
            $writer =  \PhpOffice\PhpSpreadsheet\IOFactory::createWriter($spreadsheet, "Xlsx");
            $writer->save('assets/format_data/Laporan_retur_barang.xlsx');
            force_download(site_url('assets/format_data/Laporan_retur_barang.xlsx'),NULL);
        
    }
    public function download_Laporan_retur_barang($iddesa){		
	    force_download('assets/format_data/Laporan_retur_barang.xlsx',NULL);
	}

    function eksport_laporan_kulakan() {
        $search = $this->input->post('search_omset');
        $toko = $this->input->post('pilihtoko');
        $tgl = explode(' - ', $this->input->post('tgl'));
        $tgl_awal = explode('/', $tgl[0]);
        $tglawal = $tgl_awal[2] . '-' . $tgl_awal[0] . '-' . $tgl_awal[1];
        $tgl_akhir = explode('/', $tgl[1]);
        $tglakhir = $tgl_akhir[2] . '-' . $tgl_akhir[0] . '-' . $tgl_akhir[1];
        $baris = $this->input->post('baris');

        $reader = new \PhpOffice\PhpSpreadsheet\Reader\Xlsx();
        $spreadsheet = $reader->load('assets/format_data/Laporan_pembelianb.xlsx');
     
        $sheet = $spreadsheet->getActiveSheet();
       
        $sheet = $spreadsheet->getActiveSheet();
        $baris_pertama = 5;

        $list = $this->Mlaporan->laporan_kulakan($search, $tglawal, $tglakhir, $toko, $baris);
            foreach ($list as $value) {
                $sheet->setCellValue('A'.$baris_pertama,$value->tanggal );
                $sheet->setCellValue('B'.$baris_pertama,$value->notatransaksi_kulakan);
                $sheet->setCellValue('C'.$baris_pertama, $value->nama_suplayer) ;
                $sheet->setCellValue('D'.$baris_pertama, $value->idbarang) ;
                $sheet->setCellValue('E'.$baris_pertama, $value->nama_barang) ;
                $sheet->setCellValue('F'.$baris_pertama, $value->hargabeli );
                $sheet->setCellValue('G'.$baris_pertama, $value->jumlah);
                $sheet->setCellValue('H'.$baris_pertama, $value->hargabeli*$value->jumlah);
                $baris_pertama++; 
            }
        $writer =  \PhpOffice\PhpSpreadsheet\IOFactory::createWriter($spreadsheet, "Xlsx");
        $writer->save('assets/format_data/Laporan_pembelian_barang.xlsx');
        force_download(site_url('assets/format_data/Laporan_pembelian_barang.xlsx'),NULL);
    }
    public function download_Laporan_pembelian_barang($iddesa){		
	    force_download('assets/format_data/Laporan_pembelian_barang.xlsx',NULL);
	}
    function export_laporan_opname_stock() {
        $tgl = explode(' - ', $this->input->post('tgl'));
        $tgl_awal = explode('/', $tgl[0]);
        $tglawal = $tgl_awal[2] . '-' . $tgl_awal[0] . '-' . $tgl_awal[1];
        $tgl_akhir = explode('/', $tgl[1]);
        $tglakhir = $tgl_akhir[2] . '-' . $tgl_akhir[0] . '-' . $tgl_akhir[1];

        $reader = new \PhpOffice\PhpSpreadsheet\Reader\Xlsx();
        $spreadsheet = $reader->load('assets/format_data/Laporan_stock_opname.xlsx');
     
        $sheet = $spreadsheet->getActiveSheet();
       
        $sheet = $spreadsheet->getActiveSheet();
        $baris_pertama = 6;
        
        $list = $this->Mlaporan->laporan_opname_stock( $tglawal, $tglakhir);
        foreach ($list as $value) {
            $sheet->setCellValue('A'.$baris_pertama,$value->nama );
            $sheet->setCellValue('B'.$baris_pertama,' '. date('d-m-Y H:i:s ', strtotime($value->tanggal_stock_opname)) );
            $sheet->setCellValue('C'.$baris_pertama, $value->idbarang) ;
            $sheet->setCellValue('D'.$baris_pertama, $value->nama_barang) ;
            $sheet->setCellValue('E'.$baris_pertama, $value->barcode) ;
            $sheet->setCellValue('F'.$baris_pertama, $value->stock );
            $sheet->setCellValue('G'.$baris_pertama, $value->opname);
            $sheet->setCellValue('H'.$baris_pertama, $value->selisi);
            $sheet->setCellValue('I'.$baris_pertama, $value->harga);
            $sheet->setCellValue('J'.$baris_pertama, $value->total_selisih);
            
            $baris_pertama++; 
        }
            
        $writer =  \PhpOffice\PhpSpreadsheet\IOFactory::createWriter($spreadsheet, "Xlsx");
        $writer->save('assets/format_data/Laporan_stock_opname_barang.xlsx');
        force_download(site_url('assets/format_data/Laporan_stock_opname_barang.xlsx'),NULL);
    
    }
    public function download_Laporan_stock_opname_barang($iddesa){		
	    force_download('assets/format_data/Laporan_stock_opname_barang.xlsx',NULL);
	}
    function export_putaran_kas() {
        $search = $this->input->post('search_block_stock');
        $toko = $this->input->post('pilihtoko');
        $tgl = explode(' - ', $this->input->post('tgl'));
        $tgl_awal = explode('/', $tgl[0]);
        $tglawal = $tgl_awal[2] . '-' . $tgl_awal[0] . '-' . $tgl_awal[1];
        $tgl_akhir = explode('/', $tgl[1]);
        $tglakhir = $tgl_akhir[2] . '-' . $tgl_akhir[0] . '-' . $tgl_akhir[1];
        $baris = $this->input->post('baris');
        $reader = new \PhpOffice\PhpSpreadsheet\Reader\Xlsx();
        $spreadsheet = $reader->load('assets/format_data/Laporan_kas_keuangan.xlsx');
     
        $sheet = $spreadsheet->getActiveSheet();
       
        $sheet = $spreadsheet->getActiveSheet();
        $baris_pertama = 6;
        $list = $this->Mlaporan->laporan_kas($search, $tglawal, $tglakhir, $toko, $baris);
        if (count($list) > 0) {
            foreach ($list as $value) {
                $sheet->setCellValue('A'.$baris_pertama,' '. date('d-m-Y H:i:s ', strtotime($value->tgl)) );
                $sheet->setCellValue('B'.$baris_pertama, $value->ket);
                $sheet->setCellValue('C'.$this->rupiah($baris_pertama, $value->saldo_awal) );
                $sheet->setCellValue('D'.$this->rupiah($baris_pertama, $value->Masuk) );
                $sheet->setCellValue('E'.$this->rupiah($baris_pertama, $value->Keluar) );
                $sheet->setCellValue('F'.$this->rupiah($baris_pertama, $value->koreksi) );
                $sheet->setCellValue('G'.$this->rupiah($baris_pertama, $value->saldo_akhir) );
                
                $baris_pertama++; 
            }
        } 
        $writer =  \PhpOffice\PhpSpreadsheet\IOFactory::createWriter($spreadsheet, "Xlsx");
        $writer->save('assets/format_data/Laporan_keuangan_toko.xlsx');
        force_download(site_url('assets/format_data/Laporan_keuangan_toko.xlsx'),NULL);
    }
    public function download_Laporan_keuangan_toko($iddesa){		
	    force_download('assets/format_data/Laporan_keuangan_toko.xlsx',NULL);
	}




    function export_data_prive() {
        $search = $this->input->post('search_omset');
        $toko = $this->input->post('pilihtoko');
        $tgl = explode(' - ', $this->input->post('tgl'));
        $tgl_awal = explode('/', $tgl[0]);
        $tglawal = $tgl_awal[2] . '-' . $tgl_awal[0] . '-' . $tgl_awal[1];
        $tgl_akhir = explode('/', $tgl[1]);
        $tglakhir = $tgl_akhir[2] . '-' . $tgl_akhir[0] . '-' . $tgl_akhir[1];

        $baris = $this->input->post('baris');

        $reader = new \PhpOffice\PhpSpreadsheet\Reader\Xlsx();
        $spreadsheet = $reader->load('assets/format_data/Laporan_penjualanb.xlsx');
     
        $sheet = $spreadsheet->getActiveSheet();
       
        $sheet = $spreadsheet->getActiveSheet();
        $baris_pertama = 5;



        $list = $this->Mlaporan->laporan_prive($search, $tglawal, $tglakhir, $toko, $baris);
        
        if (count($list) > 0) {
            $no = 1;
            foreach ($list as $value) {
                if ($value->idcustomer == 0 || $value->idcustomer == "" || $value->jenis_harga_penjualan == "ecer") {
                    $nm_c = 'customer ecer (-)';
                    $print = "print_ecer";
                } else {
                    $nm_c = $value->nama_customer;
                    $print = "print_grosir";
                }
                $sheet->setCellValue('A'.$baris_pertama,' '. date('d-m-Y H:i:s ', strtotime($value->tanggal)) );
                $sheet->setCellValue('B'.$baris_pertama, $value->notatransaksi_penjualan_customer);
                $sheet->setCellValue('C'.$baris_pertama,  $nm_c );
                if($value->jenis_bayar=="cicil"){
                    $sheet->setCellValue('D'.$baris_pertama,  "Kredit" );
                }else{
                    $sheet->setCellValue('D'.$baris_pertama,  "Tunai" );
                }
                $sheet->setCellValue('E'.$baris_pertama,  $value->idbarang );
                $sheet->setCellValue('F'.$baris_pertama,  $value->nama_barang );
                $sheet->setCellValue('G'.$baris_pertama,  $value->hargajual - $value->diskon );
                $sheet->setCellValue('H'.$baris_pertama,  $value->hargabeli );
                $sheet->setCellValue('I'.$baris_pertama,  ( $value->hargajual - $value->diskon)-$value->hargabeli) ;
                $sheet->setCellValue('J'.$baris_pertama,   $value->jumlah)  ;
                $sheet->setCellValue('K'.$baris_pertama,  $value->laba);

                $baris_pertama++;
            
            }
           
    
        } 
        $writer =  \PhpOffice\PhpSpreadsheet\IOFactory::createWriter($spreadsheet, "Xlsx");
        $writer->save('assets/format_data/Laporan_prive_penjualan_barang.xlsx');
        force_download(site_url('assets/format_data/Laporan_prive_penjualan_barang.xlsx'),NULL);
    }
    public function download_laporan_penjualanprive_barang($iddesa){		
	    force_download('assets/format_data/Laporan_prive_penjualan_barang.xlsx',NULL);
	}

    function export_data_omset() {
        $search = $this->input->post('search_omset');
        $toko = $this->input->post('pilihtoko');
        $tgl = explode(' - ', $this->input->post('tgl'));
        $tgl_awal = explode('/', $tgl[0]);
        $tglawal = $tgl_awal[2] . '-' . $tgl_awal[0] . '-' . $tgl_awal[1];
        $tgl_akhir = explode('/', $tgl[1]);
        $tglakhir = $tgl_akhir[2] . '-' . $tgl_akhir[0] . '-' . $tgl_akhir[1];

        $baris = $this->input->post('baris');

        $reader = new \PhpOffice\PhpSpreadsheet\Reader\Xlsx();
        $spreadsheet = $reader->load('assets/format_data/Laporan_penjualanb.xlsx');
     
        $sheet = $spreadsheet->getActiveSheet();
       
        $sheet = $spreadsheet->getActiveSheet();
        $baris_pertama = 5;



        $list = $this->Mlaporan->laporan_omset($search, $tglawal, $tglakhir, $toko, $baris);
        
        if (count($list) > 0) {
            $no = 1;
            foreach ($list as $value) {
                if ($value->idcustomer == 0 || $value->idcustomer == "" || $value->jenis_harga_penjualan == "ecer") {
                    $nm_c = 'customer ecer (-)';
                    $print = "print_ecer";
                } else {
                    $nm_c = $value->nama_customer;
                    $print = "print_grosir";
                }
                
             
                
                $sheet->setCellValue('A'.$baris_pertama,' '. date('d-m-Y H:i:s ', strtotime($value->tanggal)) );
                $sheet->setCellValue('B'.$baris_pertama, $value->notatransaksi_penjualan_customer);
                $sheet->setCellValue('C'.$baris_pertama,  $value->jenis_harga_penjualan  );
                $sheet->setCellValue('D'.$baris_pertama,  $value->nama );
                $sheet->setCellValue('E'.$baris_pertama,  $value->nama_marketing );
                $sheet->setCellValue('F'.$baris_pertama,  $nm_c  );
                $sheet->setCellValue('G'.$baris_pertama,  $this->rupiah($value->totalbayar + $value->ongkir) );

                $baris_pertama++;
            
            }
           
    
        } 
        $writer =  \PhpOffice\PhpSpreadsheet\IOFactory::createWriter($spreadsheet, "Xlsx");
        $writer->save('assets/format_data/Laporan_penjualan_barang.xlsx');
        force_download(site_url('assets/format_data/Laporan_penjualan_barang.xlsx'),NULL);
    }
    function export_data_pengeluaran_perusahaan() {
        
        $baris = $this->input->post('baris');

        $reader = new \PhpOffice\PhpSpreadsheet\Reader\Xlsx();
        $spreadsheet = $reader->load('assets/format_data/Laporan_pengeluaran.xlsx');
     
        $sheet = $spreadsheet->getActiveSheet();
       
        $sheet = $spreadsheet->getActiveSheet();
        $baris_pertama = 5;

        $toko = $this->input->post('toko');
        $nama_pengeluaran = $this->input->post('search_nama_pengeluaran');
        $baris = $this->input->post('baris');
        $tgl = explode(' - ', $this->input->post('tgl'));
        $tgl_awal = explode('/', $tgl[0]);
        $tglawal = $tgl_awal[2] . '-' . $tgl_awal[0] . '-' . $tgl_awal[1];
        $tgl_akhir = explode('/', $tgl[1]);
        $tglakhir = $tgl_akhir[2] . '-' . $tgl_akhir[0] . '-' . $tgl_akhir[1];
        $total_pengeluaran =0;
        $list = $this->Mmaster->search_pengeluaran($nama_pengeluaran, $toko,$baris,$tglawal, $tglakhir);
        if (count($list) > 0) {
            $no = 1;
            foreach ($list as $value) {
                $sheet->setCellValue('A'.$baris_pertama,' '. $value->tanggal );
                $sheet->setCellValue('B'.$baris_pertama, $value->keterangan);
                $sheet->setCellValue('C'.$baris_pertama, $value->nominal_pengeluaran  );
                $baris_pertama++;
            
            }
           
    
        } 
        $writer =  \PhpOffice\PhpSpreadsheet\IOFactory::createWriter($spreadsheet, "Xlsx");
        $writer->save('assets/format_data/Laporan_pengeluaran_perusahaan.xlsx');
        force_download(site_url('assets/format_data/Laporan_pengeluaran_perusahaan.xlsx'),NULL);
    }
    function export_data_modal_perusahaan() {
        
        $baris = $this->input->post('baris');

        $reader = new \PhpOffice\PhpSpreadsheet\Reader\Xlsx();
        $spreadsheet = $reader->load('assets/format_data/Laporan_pengeluaran.xlsx');
     
        $sheet = $spreadsheet->getActiveSheet();
       
        $sheet = $spreadsheet->getActiveSheet();
        $baris_pertama = 5;

        $toko = $this->input->post('toko');
        $nama_pengeluaran = $this->input->post('search_nama_pengeluaran');
        $baris = $this->input->post('baris');
        $tgl = explode(' - ', $this->input->post('tgl'));
        $tgl_awal = explode('/', $tgl[0]);
        $tglawal = $tgl_awal[2] . '-' . $tgl_awal[0] . '-' . $tgl_awal[1];
        $tgl_akhir = explode('/', $tgl[1]);
        $tglakhir = $tgl_akhir[2] . '-' . $tgl_akhir[0] . '-' . $tgl_akhir[1];
        $total_pengeluaran =0;
        $list = $this->Mmaster->search_tambahmodal($nama_pengeluaran, $toko,$baris,$tglawal, $tglakhir);
        if (count($list) > 0) {
            $no = 1;
            foreach ($list as $value) {
                $sheet->setCellValue('A'.$baris_pertama,' '. $value->tanggal );
                $sheet->setCellValue('B'.$baris_pertama, $value->keterangan);
                $sheet->setCellValue('C'.$baris_pertama, $value->nominal_pengeluaran  );
                $baris_pertama++;
            
            }
           
    
        } 
        $writer =  \PhpOffice\PhpSpreadsheet\IOFactory::createWriter($spreadsheet, "Xlsx");
        $writer->save('assets/format_data/Laporan_pengeluaran_perusahaan.xlsx');
        force_download(site_url('assets/format_data/Laporan_pengeluaran_perusahaan.xlsx'),NULL);
    }
    public function download_laporan_pengeluaran_perusahaan($iddesa){		
	    force_download('assets/format_data/Laporan_pengeluaran_perusahaan.xlsx',NULL);
	}
    public function download_laporan_penjualan_barang($iddesa){		
	    force_download('assets/format_data/Laporan_penjualan_barang.xlsx',NULL);
	}
    public function export_data_piutang_customer() {
        $search = $this->input->post('search_nm');
        $toko = $this->input->post('pilihtoko');
        $tgl = explode(' - ', $this->input->post('tgl'));
        $tgl_awal = explode('/', $tgl[0]);
        $tglawal = $tgl_awal[2] . '-' . $tgl_awal[0] . '-' . $tgl_awal[1];
        $tgl_akhir = explode('/', $tgl[1]);
        $tglakhir = $tgl_akhir[2] . '-' . $tgl_akhir[0] . '-' . $tgl_akhir[1];

        $reader = new \PhpOffice\PhpSpreadsheet\Reader\Xlsx();
        $spreadsheet = $reader->load('assets/format_data/Laporan_piutangc.xlsx');
     
        $sheet = $spreadsheet->getActiveSheet();
       
        $sheet = $spreadsheet->getActiveSheet();
        $baris_pertama = 5;
        $filter = $this->input->post('filter');


        $list = $this->Mlaporan->laporan_hutang_customer($search, $tglawal, $tglakhir, $toko);
        if (count($list) > 0) {
            $no = 1;
            foreach ($list as $value) {
                if($filter=="semua"){
                    if ($value->idcustomer == 0 || $value->idcustomer == "") {
                        $nm_c = 'customer ecer (-)';
                    } else {
                        $nm_c = $value->nama_customer;
                    }
                    if($value->status_lunas=='lunas'){
    
                        $sheet->setCellValue('A'.$baris_pertama,' '. date('d-m-Y H:i:s ', strtotime($value->tanggal_jatuh_tempoh)));
                        $sheet->setCellValue('B'.$baris_pertama, date('d-m-Y H:i:s ', strtotime($value->tanggal)));
                        $sheet->setCellValue('C'.$baris_pertama,  $value->notatransaksi_penjualan_customer);
                        $sheet->setCellValue('D'.$baris_pertama, $value->jenis_harga_penjualan);
                        $sheet->setCellValue('E'.$baris_pertama, $value->hp_customer);
                        $sheet->setCellValue('F'.$baris_pertama, $nm_c);
                        $sheet->setCellValue('G'.$baris_pertama, '0');
                        $sheet->setCellValue('H'.$baris_pertama, $value->status_lunas);
                        $baris_pertama++;
                    }else{
                        $sheet->setCellValue('A'.$baris_pertama,' '. date('d-m-Y H:i:s ', strtotime($value->tanggal_jatuh_tempoh)));
                        $sheet->setCellValue('B'.$baris_pertama, date('d-m-Y H:i:s ', strtotime($value->tanggal)));
                        $sheet->setCellValue('C'.$baris_pertama,  $value->notatransaksi_penjualan_customer);
                        $sheet->setCellValue('D'.$baris_pertama, $value->jenis_harga_penjualan);
                        $sheet->setCellValue('E'.$baris_pertama, $value->hp_customer);
                        $sheet->setCellValue('F'.$baris_pertama, $nm_c);
                        $sheet->setCellValue('G'.$baris_pertama, $this->rupiah(($value->totalbayar + $value->ongkir)-$value->bayar-$value->bayar_tf));
                        $sheet->setCellValue('H'.$baris_pertama, $value->status_lunas);
                        $baris_pertama++;
                    }
                }else if($filter=="lunas"){
                    if ($value->idcustomer == 0 || $value->idcustomer == "") {
                        $nm_c = 'customer ecer (-)';
                    } else {
                        $nm_c = $value->nama_customer;
                    }
                    if($value->status_lunas=='lunas'){
    
                        $sheet->setCellValue('A'.$baris_pertama,' '. date('d-m-Y H:i:s ', strtotime($value->tanggal_jatuh_tempoh)));
                        $sheet->setCellValue('B'.$baris_pertama, date('d-m-Y H:i:s ', strtotime($value->tanggal)));
                        $sheet->setCellValue('C'.$baris_pertama,  $value->notatransaksi_penjualan_customer);
                        $sheet->setCellValue('D'.$baris_pertama, $value->jenis_harga_penjualan);
                        $sheet->setCellValue('E'.$baris_pertama, $value->hp_customer);
                        $sheet->setCellValue('F'.$baris_pertama, $nm_c);
                        $sheet->setCellValue('G'.$baris_pertama, '0');
                        $sheet->setCellValue('H'.$baris_pertama, $value->status_lunas);
                        $baris_pertama++;
                    }
                }else{
                    if($value->status_lunas=='utang'){
                        $sheet->setCellValue('A'.$baris_pertama,' '. date('d-m-Y H:i:s ', strtotime($value->tanggal_jatuh_tempoh)));
                        $sheet->setCellValue('B'.$baris_pertama, date('d-m-Y H:i:s ', strtotime($value->tanggal)));
                        $sheet->setCellValue('C'.$baris_pertama,  $value->notatransaksi_penjualan_customer);
                        $sheet->setCellValue('D'.$baris_pertama, $value->jenis_harga_penjualan);
                        $sheet->setCellValue('E'.$baris_pertama, $value->hp_customer);
                        $sheet->setCellValue('F'.$baris_pertama, $nm_c);
                        $sheet->setCellValue('G'.$baris_pertama, '0');
                        $sheet->setCellValue('H'.$baris_pertama, $value->status_lunas);
                        $baris_pertama++;    
                    }
                }
                
                
            }
        }
        $writer =  \PhpOffice\PhpSpreadsheet\IOFactory::createWriter($spreadsheet, "Xlsx");
        $writer->save('assets/format_data/Laporan_piutang_customer.xlsx');
        force_download(site_url('assets/format_data/Laporan_piutang_customer.xlsx'),NULL);

    }
    public function download_laporan_piutang_customer($iddesa){		
	    force_download('assets/format_data/Laporan_piutang_customer.xlsx',NULL);
	}
    public function export_data_barang() {

        $toko = $this->input->post('toko');
        $nama_barang = $this->input->post('search_nama_barang');
        $filter_stock = $this->input->post('filter_stock');
        $baris = $this->input->post('baris');

            //   $output = array(
            //             'data' => $this->Mmaster->search_barang($nama_barang, $filter_stock, $toko,$baris)
            //         );
        
        $reader = new \PhpOffice\PhpSpreadsheet\Reader\Xlsx();
        $spreadsheet = $reader->load('assets/format_data/Laporan_stock.xlsx');
     
        $sheet = $spreadsheet->getActiveSheet();
       
        $sheet = $spreadsheet->getActiveSheet();
        $baris_pertama = 5;
        $baris_judul = 2;
        
        $data_value_desa=$this->Mmaster->search_barang_eksport_excel($nama_barang, $filter_stock, $toko);
        foreach($data_value_desa as $datavalue){
            $sheet->setCellValue('A'.$baris_judul,' LAPORAN STOCK BARANG | Nama Toko : '. $datavalue->namatoko.'|Bulan : '.date('m').'| Tahun : '.date('Y'));
            $sheet->setCellValue('A'.$baris_pertama,' '. $datavalue->barcode);
            $sheet->setCellValue('B'.$baris_pertama, $datavalue->nama_barang);
            $sheet->setCellValue('C'.$baris_pertama, $datavalue->hargabeli);
            $sheet->setCellValue('D'.$baris_pertama, $datavalue->hecer1);
            $sheet->setCellValue('E'.$baris_pertama, $datavalue->hecer2);
            $sheet->setCellValue('F'.$baris_pertama, $datavalue->hgrosir1);
            $sheet->setCellValue('G'.$baris_pertama, $datavalue->stock);
            $sheet->setCellValue('H'.$baris_pertama, $datavalue->isibarang);
            $sheet->setCellValue('I'.$baris_pertama, $datavalue->stock*$datavalue->hargabeli);
            
            $baris_pertama++;
                
        }
        
        
        
        $writer =  \PhpOffice\PhpSpreadsheet\IOFactory::createWriter($spreadsheet, "Xlsx");
        $writer->save('assets/format_data/Laporan_stock_barang.xlsx');
         force_download(site_url('assets/format_data/Laporan_stock_barang.xlsx'),NULL);
           
    }
    
    public function download_laporan_barang($iddesa){		
	    force_download('assets/format_data/Laporan_stock_barang.xlsx',NULL);
	}

    public function download_format_siswa(){				
		force_download('assets/format_data/Laporan_stock_barang.xls',NULL);
	//	redirect('menu-siswa');
	}
//-------------------------------------------------------- master entri customer
    public function customer() {
        $output = array(
            'jcustomer' => $this->Mgrafik->jmlcustomer()
        );
        $this->load->view('v-admin/customer', $output);
    }

    public function form_tambah_customer() {
        $this->load->view('v-admin/customer_tambah');
    }

    public function form_edit_customer() {
        $id = $this->input->post('id');
        $data_customer = $this->Mmaster->where_kode_customer($id);
        $output = array(
            'id' => $id,
            'nama' => $data_customer->nama_customer,
            'alamat' => $data_customer->alamat_customer,
            'wilayah' => $data_customer->wilayah_customer,
            'hp' => $data_customer->hp_customer,
            'status' => $data_customer->status_customer,
            'idmarketing' => $data_customer->idmarketing,
            'jenis_customer' => $data_customer->jenis_customer,
            'nama_marketing' => $data_customer->nama_marketing,
            'saldo_dp' => $data_customer->saldo_dp,
            
            'kode_customer' => $data_customer->kode_customer
        );
        $this->load->view('v-admin/customer_edit', $output);
    }

//------------------------------------------------------- master entri marketing
    public function marketing() {
        $output = array(
            'jmarketing' => $this->Mgrafik->jmlmarketing()
        );
        $this->load->view('v-admin/marketing', $output);
    }

    public function form_tambah_marketing() {
        $this->load->view('v-admin/marketing_tambah');
    }

    public function form_edit_marketing() {
        $id = $this->input->post('id');
        $data_marketing = $this->Mmaster->where_kode_marketing($id);
        $output = array(
            'id' => $id,
            'nama' => $data_marketing->nama_marketing,
            'alamat' => $data_marketing->alamat_marketing,
            'hp' => $data_marketing->hp_marketing
        );
        $this->load->view('v-admin/marketing_edit', $output);
    }

//-------------------------------------------------------- master entri suplayer
    public function suplayer() {
        $output = array(
            'jsuplayer' => $this->Mgrafik->jmlsuplayer()
        );
        $this->load->view('v-admin/suplayer', $output);
    }

    public function form_tambah_suplayer() {
        $this->load->view('v-admin/suplayer_tambah');
    }

    public function form_edit_suplayer() {
        $id = $this->input->post('id');
        $data_suplayer = $this->Mmaster->where_kode_suplayer($id);
        $output = array(
            'id' => $id,
            'nama' => $data_suplayer->nama_suplayer,
            'alamat' => $data_suplayer->alamat_suplayer,
            'hp' => $data_suplayer->hp_suplayer,
            'saldo_dp' => $data_suplayer->saldo_dp,
            'kode_suplayer' => $data_suplayer->kode_suplayer,
            
        );
        $this->load->view('v-admin/suplayer_edit', $output);
    }

    //-------------------------------------------------------- master entri petugas
    public function petugas() {
        $output = array(
            'jpetugas' => $this->Mgrafik->jmlpetugas()
        );
        $this->load->view('v-admin/petugas', $output);
    }

    public function form_tambah_petugas() {
        $output= array(
            'toko'=>$this->Mmaster->toko()
        );
        $this->load->view('v-admin/petugas_tambah',$output);
    }

    public function form_edit_petugas() {
        $id = $this->input->post('id');
        $data_petugas = $this->Mmaster->where_kode_petugas($id);
        $output = array(
            'id' => $id,
            'nama' => $data_petugas->nama,
            'alamat' => $data_petugas->alamat,
            'hp' => $data_petugas->hp,
            'uname' => $data_petugas->username,
            'pass' => $data_petugas->password,
            'jabatan' => $data_petugas->jabatan,
            'status' => $data_petugas->statususer
        );
        $this->load->view('v-admin/petugas_edit', $output);
    }
    //-------------------------------------------------------- master entri toko
    public function toko() {
        $output = array(
            'jtoko' => $this->Mgrafik->jmltoko()
        );
        $this->load->view('v-admin/toko', $output);
    }

    public function form_tambah_toko() {
        $output= array(
            'toko'=>$this->Mmaster->toko()
        );
        $this->load->view('v-admin/toko_tambah',$output);
    }

    public function form_edit_toko() {
        $id = $this->input->post('id');
        $data_toko = $this->Mmaster->where_kode_toko($id);
        $output = array(
            'id' => $id,
            'nama' => $data_toko->nama,
            'alamat' => $data_toko->alamat_toko,
            'nominal_modal' => $data_toko->nominal_modal
        );
        $this->load->view('v-admin/toko_edit', $output);
    }
//----------------------------------------------------------- transaksi penjualan
    public function pindah_stock() {
        $output = array(
            'toko'=>$this->Mmaster->toko()
        );
        $this->load->view('v-admin/pindah_stock', $output);
    }
//----------------------------------------------------------- transaksi penjualan
    public function transaksi_penjualan() {
        $idptgs = $this->session->userdata['logged_in']['idptgs'];
        $nota_terakhir = $this->Mpenjualan->nota_terakhir_penjualan($idptgs);
        $countnota_terakhir = count($nota_terakhir);
        if ($countnota_terakhir == 0) {
            $nomer_nota_baru = '1';
        } else {
            $array_nomer_nota = array();
            foreach ($nota_terakhir as $value) {
                $nota = $value->notatransaksi_penjualan_customer;
                $nomer_nota = explode('-', $nota);
                $array_nomer_nota[] = $nomer_nota[1];
            }
            rsort($array_nomer_nota);
            $nomer_nota_baru = $array_nomer_nota[0] + 1;
        }
        $notanya = 'KN' . $this->session->userdata['logged_in']['idptgs'] . '-' . $nomer_nota_baru;
        $output = array(
            'nofaktur' => $notanya
        );
        $this->load->view('v-admin/transaksi_penjualan', $output);
    }

//----------------------------------------------------------- transaksi pembelian
   
  public function transaksi_pembelian() {
        $idptgs = $this->session->userdata['logged_in']['idptgs'];
        $nota_terakhir = $this->Mpembelian->nota_terakhir_pembelian($idptgs);
        $countnota_terakhir = count($nota_terakhir);
        if ($countnota_terakhir == 0) {
            $nomer_nota_baru = '1';
        } else {
            $array_nomer_nota = array();
            $tahun="";
            $bulan="";
            
            foreach ($nota_terakhir as $value) {
                $nota = $value->notatransaksi_kulakan;
                $nomer_nota = explode('-', $nota);
                $array_nomer_nota[] = $nomer_nota[1];
                $tahun=$value->tahun;
                $bulan=$value->bulan;
            }
            rsort($array_nomer_nota); // sort nomer nota paling besar ke kecil
            $nomer_nota_baru = $array_nomer_nota[0] + 1; //mengambil nomer nota paling besar
        }
        //----------------------------------------------------------------------
        $notanya = 'BL' . $this->session->userdata['logged_in']['idptgs'] . ''.date('Y').''.date('m').'-' . $nomer_nota_baru;

        $output = array(
            'nofaktur' => $notanya,
            'jenisbarang'=>$this->Mmaster->pilihjenisbarang()
        );
        $this->load->view('v-admin/transaksi_pembelian',$output);
    }
//----------------------------------------------------------------- nota pending
    public function nota_pending() {
        $output = array(
            'toko'=>$this->Mmaster->toko()
        );
        $this->load->view('v-admin/nota_pending',$output);
    }

    public function form_edit_nota_pending() {
        $nota = $this->input->post('nota');
        $output = array(
            'penjualan' => $this->Mpending->nota_penjulan_customer($nota),
            'detail_penjualan' => $this->Mpending->detail_nota_penjulan_customer($nota,$this->input->post('pilihtoko')),
        );
        $this->load->view('v-admin/nota_pending_edit', $output);
    }

//----------------------------------------------------- laporan piutang customer
    public function piutang_customer() {
        $output = array(
            'toko'=>$this->Mmaster->toko()
        );
        $this->load->view('v-admin/piutang_customer',$output);
    }

    public function piutang_suplayer() {
        $output = array(
            'toko'=>$this->Mmaster->toko()
        );
        $this->load->view('v-admin/piutang_suplayer',$output);
    }

    public function form_edit_piutang_customer() {
        $id = $this->input->post('id');
        $data = $this->Mlaporan->nota_penjulan_customer($id);
        $output = array(
            'nota' => $data->notatransaksi_penjualan_customer,
            'nama' => $data->nama_customer,
            'ongkir' => $data->ongkir,
            'totalbayar' => $data->totalbayar,
            'bayar' => $data->bayar,
            'bayar_tf' => '0',
            'idcustomer'=>$data->idcustomer
        );
        $this->load->view('v-admin/piutang_customer_edit', $output); 
    }

    public function form_edit_piutang_suplayer() {
        $id = $this->input->post('id');
        $data = $this->Mlaporan->nota_penjulan_suplayer($id);
        $output = array(
            'nota' => $data->notatransaksi_kulakan,
            'nama' => $data->nama_suplayer,
            'totalbayar' => $data->totalbayar,
            'bayar' => $data->bayar,
            'idsuplayer'=>$data->idsuplayer
        );
        $this->load->view('v-admin/piutang_suplayer_edit', $output); 
    }

//----------------------------------------------------- laporan omset
    public function omset() {
        $output = array(
            'toko'=>$this->Mmaster->toko()
        );
        $this->load->view('v-admin/omset',$output);
    }
    public function hakases() {
        $output = array(
            'toko'=>$this->Mmaster->toko()
        );
        $this->load->view('v-admin/hakases',$output);
    }
    public function laporan_casback() {
        $output = array(
            'toko'=>$this->Mmaster->toko()
        );
        $this->load->view('v-admin/laporan_casback',$output);
    }

    public function pembelian() {
        $output = array(
            'toko'=>$this->Mmaster->toko()
        );
        $this->load->view('v-admin/pembelian',$output);
    }

    public function prive() {
        $output = array(
            'toko'=>$this->Mmaster->toko()
        );
        $this->load->view('v-admin/prive',$output);
    }

//----------------------------------------------------- laporan income
    public function income() {
        $output = array(
            'toko'=>$this->Mmaster->toko()
        );
        $this->load->view('v-admin/income',$output);
    }
    //----------------------------------------------------- history
public function histori_barang() {
        $output = array(
            'jbarang' => $this->Mgrafik->jmlbarang(),
            'toko'=>$this->Mmaster->toko()
        );
        $this->load->view('v-admin/histori_barang', $output);
    }
//----------------------------------------------------- Grafik
    public function grafik() {
        $data_omset_pertahun = $this->Mgrafik->grafik_pertahun_omset();
        foreach ($data_omset_pertahun as $value) {
            $bulan_omset[] = $value->bulan;
            $omset[] = $value->omset;
        }
        $data_omset_pertahun_income = $this->Mgrafik->grafik_pertahun_income();
        foreach ($data_omset_pertahun_income as $value) {
            $bulan_income[] = $value->bulan;
            $income[] = $value->income;
        }
        $output = array(
            'bulan_omset' => $bulan_omset,
            'omset' => $omset,
            'bulan_income' => $bulan_income,
            'income' => $income
        );
//         echo json_encode($income);
        $this->load->view('v-admin/grafik', $output);
    }
    
     public function block_stock() {
        $output = array(
            'toko'=>$this->Mmaster->toko()
        );
        $this->load->view('v-admin/block_stock',$output);
    }

    public function retur_barangcustomer() {
        $output = array(
            'toko'=>$this->Mmaster->toko()
        );
        $this->load->view('v-admin/retur_customer_barang',$output);
    }
    
    public function retur_barangsuplayer() {
        $output = array(
            'toko'=>$this->Mmaster->toko()
        );
        $this->load->view('v-admin/retur_suplayer_barang',$output);
    }

    public function opname_stock() {
        $output = array(
            'toko'=>$this->Mmaster->toko()
        );
        $this->load->view('v-admin/opname_stock',$output);
    }

    public function putaran_kas() {
        $output = array(
            'toko'=>$this->Mmaster->toko()
        );
        $this->load->view('v-admin/putaran_kas',$output);
    }

}
