<?php

defined('BASEPATH') OR exit('No direct script access allowed');

class Admin_laporan extends CI_Controller {

    public function __construct() {
        parent::__construct();
        $this->load->model('Mlaporan');
        $this->load->model('Mpenjualan');
        $this->load->model('Mpembelian');
        
    }

    public function rupiah($angka) {
        $hasil_rupiah = number_format($angka, 0, '.', '.');
        return $hasil_rupiah;
    }
    public function laporan_piutang_customer() {
        $search = $this->input->post('search_nm');
        $toko = $this->input->post('pilihtoko');

        $filter = $this->input->post('filter');

        $list = $this->Mlaporan->laporan_hutang_customer($search, $toko);
            $no = 1;
            foreach ($list as $value) {
                $row = array();
                $row1= array();
                if ($value->idcustomer == 0 || $value->idcustomer == "") {
                    $nm_c = 'customer ecer (-)';
                } else {
                    $nm_c = $value->nama_customer;
                }
                            $row[] = '<tr>';
                            $row[] = '<td><span  >' . $no++ . '</span></td>';
                            $row[] = '<td><span  >' . $value->nama. '</span></td>';
                            $row[] = '<td><span  >' . date('d-m-Y H:i:s ', strtotime($value->tanggal)) . '</span></td>';
                            $row[] = '<td><span  >' . $value->notatransaksi_penjualan_customer . '</span></td>';
                            $row[] = '<td><span  >' . $value->jenis_harga_penjualan . '</span></td>';
                            $row[] = '<td><span  >' . $value->hp_customer . '</span></td>';
                            $row[] = '<td><span  >' . $nm_c . '</span></td>';
                            $row[] = '<td><span  >' . $this->rupiah( ($value->totalbayar + $value->ongkir)-$value->bayar ) . '</span></td>';
                            $row[] = '<td><label >Status : <span  >' . $value->status_lunas . '</span></label></span></td>';
                            if(($this->session->userdata['logged_in']['level']) <>"Pemilik"){
                                $row[] = '<td><a href="#" onclick="form_edit_piutang_customer(`' . $value->notatransaksi_penjualan_customer . '`)"><i class="fas fa-edit"></i></button></a></td>';
                                $row[] = '<td><a href="#" data-toggle="modal" data-target="#modal-lg" onclick="info_nota(`' . $value->notatransaksi_penjualan_customer . '`)"><i class="fas fa-search"></i></button></a></td>';
                                $row[] = '<td><a href="#" data-toggle="modal" data-target="#modal-lghistory" onclick="historypiutang_nota(`' . $value->notatransaksi_penjualan_customer . '`)"><i class="fas fa-copy"></i></button></a></td>';
     
                            }
                            $row1[] = '<tr>';
                            $row1[] = '<td><span  >' .$value->nama . '</span></td>';
                            $row1[] = '<td><span  >' . date('d-m-Y H:i:s ', strtotime($value->tanggal)) . '</span></td>';
                            $row1[] = '<td><span  >' . $value->notatransaksi_penjualan_customer . '</span></td>';
                            $row1[] = '<td><span  >' . $value->jenis_harga_penjualan . '</span></td>';
                            $row1[] = '<td><span  >' . $value->hp_customer . '</span></td>';
                            $row1[] = '<td><span  >' . $nm_c . '</span></td>';
                            $row1[] = '<td><span  >' . $this->rupiah( ($value->totalbayar + $value->ongkir)-$value->bayar ) . '</span></td>';
                            $row1[] = '<td><label >Status : <span  >' . $value->status_lunas . '</span></label></span></td>';
                            
                            
                        
                        $jum_hutang[] =  ($value->totalbayar + $value->ongkir)-$value->bayar;
                
                    
                    $row[] = '</tr>';
                    $row1[] = '</tr>';
                    
                    $data[] = $row;
                    $data1[] = $row1;
                
                
                
            }
            $sukses = 'ya';
            $jum = $this->rupiah(array_sum($jum_hutang));
            $output = array(
                'sukses' => $sukses,
                'list_hutang_customer' => $data,
                'list_hutang_customer1' => $data1,
                'jum_hutang' => $jum
            );
            echo json_encode($output);
    }

    public function laporan_piutang_suplayer1() {
        $search = $this->input->post('search_nm');
        $toko = $this->input->post('pilihtoko');
        $tgl = explode(' - ', $this->input->post('tgl'));
        $tgl_awal = explode('/', $tgl[0]);
        $tglawal = $tgl_awal[2] . '-' . $tgl_awal[0] . '-' . $tgl_awal[1];
        $tgl_akhir = explode('/', $tgl[1]);
        $tglakhir = $tgl_akhir[2] . '-' . $tgl_akhir[0] . '-' . $tgl_akhir[1];
        $list = $this->Mlaporan->laporan_hutang_suplayer($search, $tglawal, $tglakhir, $toko);
        if (count($list) > 0) {
            $no = 1;
            foreach ($list as $value) {
                $row = array();
                $nm_c = $value->nama_suplayer;
                $row[] = '<tr>';
                $row[] = '<td>' . $no++ . '</td>';
                $row[] = '<td>' . date('d-m-Y H:i:s ', strtotime($value->tanggal)) . '</td>';
                $row[] = '<td>' . $value->notatransaksi_kulakan . '</td>';
                $row[] = '<td>' . $nm_c . '</td>';
                $row[] = '<td>' . $this->rupiah($value->totalbayar-$value->bayar) . '</td>';
                $row[] = '<td><a href="#" onclick="form_edit_piutang_suplayer(`' . $value->notatransaksi_kulakan. '`)"><i class="fas fa-edit"></i></button></a></td>';
                $row[] = '<td><a href="#" data-toggle="modal" data-target="#modal-lg" onclick="info_nota(`' . $value->notatransaksi_kulakan . '`)"><i class="fas fa-search"></i></button></a></td>';
                $row[] = '</tr>';
                $data[] = $row;
                $jum_hutang[] =  ($value->totalbayar)-$value->bayar;
            }
            $sukses = 'ya';
            $jum = $this->rupiah(array_sum($jum_hutang));
        } else {
            $sukses = 'tidak';
            $data = '<tr><td colspan="8"><span class="text-danger" style="text-transform: uppercase"><b><u> ' . $search . ' </u></b></span> Data kosong ! pastikan interval waktu benar atau kata pencarian sesuai data yang ada  </td></tr>';
            $jum = 0;
        }
        $output = array(
            'sukses' => $sukses,
            'list_hutang_customer' => $data,
            'jum_hutang' => $jum
        );
        echo json_encode($output);
    }

    public function laporan_piutang_suplayer() {
        $search = $this->input->post('search_nm');
        $toko = $this->input->post('pilihtoko');
        $tgl = explode(' - ', $this->input->post('tgl'));
        $tgl_awal = explode('/', $tgl[0]);
        $tglawal = $tgl_awal[2] . '-' . $tgl_awal[0] . '-' . $tgl_awal[1];
        $tgl_akhir = explode('/', $tgl[1]);
        $tglakhir = $tgl_akhir[2] . '-' . $tgl_akhir[0] . '-' . $tgl_akhir[1];

        $list = $this->Mlaporan->laporan_hutang_suplayer($search, $tglawal, $tglakhir, $toko);
        if (count($list) > 0) {
            $no = 1;
            foreach ($list as $value) {
                $row = array();
                if ($value->idsuplayer == 0 || $value->idsuplayer == "") {
                    $nm_c = 'suplayer ecer (-)';
                } else {
                    $nm_c = $value->nama_suplayer;
                }
                $row[] = '<tr>';
                $row[] = '<td>' . $no++ . '</td>';
                $row[] = '<td>' . date('d-m-Y H:i:s ', strtotime($value->tanggal)) . '</td>';
                $row[] = '<td>' . $value->notatransaksi_kulakan . '</td>';
                $row[] = '<td>' . $nm_c . '</td>';
                $row[] = '<td>' . $this->rupiah($value->totalbayar-$value->bayar) . '</td>';
                // $row[] = '<td><a href="#" onclick="form_edit_piutang_customer(`' . $value->notatransaksi_kulakan. '`)"><i class="fas fa-edit"></i></button></a></td>';
                // $row[] = '<td><a href="#" data-toggle="modal" data-target="#modal-lg" onclick="info_nota(`' . $value->notatransaksi_kulakan . '`)"><i class="fas fa-search"></i></button></a></td>';
                // $row[] = '<td><a href="#" data-toggle="modal" data-target="#modal-lghistory" onclick="historypiutang_nota(`' . $value->notatransaksi_kulakan . '`)"><i class="fas fa-copy"></i></button></a></td>';
                $row[] = '</tr>';
                $data[] = $row;
                $jum_hutang[] =  ($value->totalbayar)-$value->bayar;
            }
            $sukses = 'ya';
            $jum = $this->rupiah(array_sum($jum_hutang));
        } else {
            $sukses = 'tidak';
            $data = '<tr><td colspan="8"><span class="text-danger" style="text-transform: uppercase"><b><u> ' . $search . ' </u></b></span> Data kosong ! pastikan interval waktu benar atau kata pencarian sesuai data yang ada  </td></tr>';
            $jum = 0;
        }
        $output = array(
            'sukses' => $sukses,
            'list_hutang_customer' => $data,
            'jum_hutang' => $jum
        );
        echo json_encode($output);
    }

    public function info_nota_suplayer() {
        $nota = $this->input->post('nota');
        $penjualan = $this->Mlaporan->nota_penjulan_suplayer($nota);

        $nc = $penjualan->nama_suplayer;
        $hc = $penjualan->hp_suplayer;
        $data_penjulan = array(
            'petugas' => $penjualan->nama,
            'tanggal' => date('d-m-Y h:i:s ', strtotime($penjualan->tanggal)),
            'nama_c' => $nc,
            'hp_c' => $nc,
        );
        $detail_penjualan = $this->Mlaporan->detail_nota_penjulan_suplayer($nota); 
        $no = 1;
        foreach ($detail_penjualan as $value) {
            $row = array();
            $row[] = '<tr>';
            $row[] = '<td>' . $no++ . '</td>';
            $row[] = '<td>' . $value->nama_barang . '</td>';
            $row[] = '<td>' . $value->jumlah . '</td>';
            $row[] = '<td>' . $this->rupiah($value->hargabeli) . '</td>';
            $row[] = '<td>' . $this->rupiah($value->jumlah * $value->hargabeli) . '</td>';
            $row[] = '</tr>';
            $data[] = $row;
        }
        $output = array(
            'penjualan' => $data_penjulan,
            'detail_penjualan' => $data
        );
        echo json_encode($output);
    }

    public function info_nota() {
        $nota = $this->input->post('nota');
        $penjualan = $this->Mlaporan->nota_penjulan_customer($nota);
        if ($penjualan->jenis_harga_penjualan === "ecer") {
            $nc = "-";
            $hc = '-';
            $nm = "-";
            $hm = "-";
        } else {
            $nc = $penjualan->nama_customer;
            $hc = $penjualan->hp_customer;
            $nm = $penjualan->nama_marketing;
            $hm = $penjualan->hp_marketing;
        }
        $data_penjulan = array(
            'petugas' => $penjualan->nama,
            'tanggal' => date('d-m-Y h:i:s ', strtotime($penjualan->tanggal)),
            'jenis' => $penjualan->jenis_harga_penjualan,
            'nama_c' => $nc,
            'hp_c' => $nc,
            'nama_m' => $nm,
            'hp_m' => $hm
        );
        $detail_penjualan = $this->Mlaporan->detail_nota_penjulan_customer($nota, $this->input->post('pilihtoko')); 
        $no = 1;
        foreach ($detail_penjualan as $value) {
            $row = array();
            $row[] = '<tr>';
            $row[] = '<td>' . $no++ . '</td>';
            $row[] = '<td>' . $value->nama_barang . '</td>';
            $row[] = '<td>' . $value->jumlah . '</td>';
            $row[] = '<td>' . $this->rupiah($value->hargajual) . '</td>';
            $row[] = '<td>' . $this->rupiah($value->jumlah * $value->hargajual) . '</td>';
            $row[] = '</tr>';
            $data[] = $row;
        }
        $output = array(
            'penjualan' => $data_penjulan,
            'detail_penjualan' => $data
        );
        echo json_encode($output);
    }

     public function infohistory_nota() {
        $nota =$this->input->post('nota');
        $penjualan = $this->Mlaporan->nota_penjulan_customerhistory($nota);
        if ($penjualan->jenis_harga_penjualan === "ecer") {
            $nc = "-";
            $hc = '-';
            $nm = "-";
            $hm = "-";
        } else {
            $nc = $penjualan->nama_customer;
            $hc = $penjualan->hp_customer;
            $nm = $penjualan->nama_marketing;
            $hm = $penjualan->hp_marketing;
        }
        $data_penjulan = array(
            'petugas' => $penjualan->nama,
            'tanggal' => date('d-m-Y h:i:s ', strtotime($penjualan->tanggal)),
            'jenis' => $penjualan->jenis_harga_penjualan,
            'nama_c' => $nc,
            'hp_c' => $nc,
            'nama_m' => $nm,
            'hp_m' => $hm
        );
        $detail_penjualan = $this->Mlaporan->detailhistory_nota_penjulan_customer($nota); 
        $no = 1;
        foreach ($detail_penjualan as $value) {
            $row = array();
            $row[] = '<tr>';
            $row[] = '<td>' . $no++ . '</td>';
            $row[] = '<td>' . $value->tanggal . '</td>';
            $row[] = '<td>' . $this->rupiah($value->bayar)  . '</td>';
            $row[] = '<td>' . $this->rupiah($value->totalbayar) . '</td>';
            $row[] = '<td>' .trim($this->rupiah($value->sisa_piutang) ,'-'). '</td>';
            $row[] = '</tr>';
            $data[] = $row;
        }
        $output = array(
            'penjualanhistory' => $data_penjulan,
            'detail_penjualanhistory' => $data
        );
        echo json_encode($output);
    }

    public function infohistory_nota_suplayer() {
        $nota =$this->input->post('nota');
        $penjualan = $this->Mlaporan->nota_penjulan_customerhistory_suplayer($nota);
        $nc = $penjualan->nama_suplayer;
        
        $data_penjulan = array(
            'petugas' => $penjualan->nama,
            'tanggal' => date('d-m-Y h:i:s ', strtotime($penjualan->tanggal)),
            'nama_c' => $nc,
            
        );
        $detail_penjualan = $this->Mlaporan->detailhistory_nota_penjulan_suplayer($nota); 
        $no = 1;
        foreach ($detail_penjualan as $value) {
            $row = array();
            $row[] = '<tr>';
            $row[] = '<td>HT' .date('Ym', strtotime($penjualan->tanggal)).'-'. $no++ . '</td>';
            $row[] = '<td>' . $value->tanggal . '</td>';
            $row[] = '<td>' . $this->rupiah($value->bayar)  . '</td>';
            $row[] = '<td>' . $this->rupiah($value->totalbayar) . '</td>';
            $row[] = '<td>' .trim($this->rupiah($value->sisa_piutang) ,'-'). '</td>';
            $row[] = '<td>' . $value->jenis_pembayaran . '</td>';
            $row[] = '</tr>';
            $data[] = $row;
        }
        $output = array(
            'penjualanhistory' => $data_penjulan,
            'detail_penjualanhistory' => $data
        );
        echo json_encode($output);
    }

    public function update_data_piutang() {
        $bayar_sebelumnya = preg_replace('/[Rp. ]/', '', str_replace(chr(194) . chr(160), ' ', $this->input->post('bayar_sebelumnya')));
        $total = preg_replace('/[Rp. ]/', '', str_replace(chr(194) . chr(160), ' ', $this->input->post('tot')));
        $bayar = preg_replace('/[Rp. ]/', '', str_replace(chr(194) . chr(160), ' ', $this->input->post('bayar')));
        $sisa = ($bayar + $bayar_sebelumnya) - $total;
        if ($sisa < 0) {
            $statuslunas = "utang";
            $ket = 'belum';
            $pesan = " <label>Customer memiliki <b class='text-danger'>sisa hutang</b>. Silahkan lakukan pembayran kembali</label>";
        } else {
            $statuslunas = "lunas";
            $ket = 'lunas';
            $pesan = " Piutang customer telah lunas";
        }
        $output_transaksi = array(
            'bayar' => $bayar + $bayar_sebelumnya,
            'status_lunas' => $statuslunas,
        );
        $this->Mlaporan->update_penjualan(array('notatransaksi_penjualan_customer' => $this->input->post('nota')), $output_transaksi);

        $output_historytransaksi_penjualan = array(//start to save tbtransaksi_penjualan
                'notatransaksi_penjualan_customer' => $this->input->post('nota'), // nota baru
                'idcustomer' => $this->input->post('idcustomer'),
                'idtoko' => $this->session->userdata['logged_in']['toko'],
                'tanggal' => date('Y-m-d H:i:s a'),
                'bayar' => preg_replace('/[Rp. ]/', '', str_replace(chr(194) . chr(160), ' ', $this->input->post('bayar'))),
                'totalbayar' => preg_replace('/[Rp. ]/', '', str_replace(chr(194) . chr(160), ' ', $this->input->post('tot'))), //total yang 
                'sisa_piutang' =>$sisa,
                
                );
        $this->Mpenjualan->simpan_historytransaksi_penjualan_customer($output_historytransaksi_penjualan);
        
        $data_detail_kas[] = array(
                'saldo' => preg_replace('/[Rp. ]/', '', $bayar),
                'tipe' =>'Masuk',
                'ket' =>'Nota Piutang Customer : '.$this->input->post('nota'),
                'tgl_up' => date('Y-m-d H:i:s'),
                'waktu_up' => date('Y-m-d H:i:s'),
                'idtoko' => $this->session->userdata['logged_in']['toko']
            );
            $this->Mpenjualan->simpan_data_detail_kas($data_detail_kas);
                
                
        $output = array(
            'pesan' => $pesan,
            'ket' => $ket
        );

        echo json_encode($output);
    }

    public function update_data_piutang_suplayer() {
        $bayar_sebelumnya = preg_replace('/[Rp. ]/', '', str_replace(chr(194) . chr(160), ' ', $this->input->post('bayar_sebelumnya')));
        $total = preg_replace('/[Rp. ]/', '', str_replace(chr(194) . chr(160), ' ', $this->input->post('tot')));
        $bayar = preg_replace('/[Rp. ]/', '', str_replace(chr(194) . chr(160), ' ', $this->input->post('bayar')));
        $sisa = ($bayar + $bayar_sebelumnya) - $total;
        if ($sisa < 0) {
            $statuslunas = "utang";
            $ket = 'belum';
            $pesan = " <label>Suplayer memiliki <b class='text-danger'>sisa hutang</b>. Silahkan lakukan pembayran kembali</label>";
        } else {
            $statuslunas = "lunas";
            $ket = 'lunas';
            $pesan = " Piutang Suplayer telah lunas";
        }
        $output_transaksi = array(
            'bayar' => $bayar + $bayar_sebelumnya,
            'status_lunas' => $statuslunas,
        );
        $this->Mlaporan->update_penjualan_suplayer(array('notatransaksi_kulakan ' => $this->input->post('nota')), $output_transaksi);

        $output_historytransaksi_penjualan = array(//start to save tbtransaksi_penjualan
                'notatransaksi_penjualan_suplayer' => $this->input->post('nota'), // nota baru
                'idsuplayer' => $this->input->post('idsuplayer'),
                'idtoko' => $this->session->userdata['logged_in']['toko'],
                'tanggal' => date('Y-m-d H:i:s a'),
                'bayar' => preg_replace('/[Rp. ]/', '', str_replace(chr(194) . chr(160), ' ', $this->input->post('bayar'))),
                'totalbayar' => preg_replace('/[Rp. ]/', '', str_replace(chr(194) . chr(160), ' ', $this->input->post('tot'))), //total yang 
                'sisa_piutang' =>$sisa
                );
        $this->Mpembelian->simpan_historytransaksi_pembelian_suplayer($output_historytransaksi_penjualan);

        $output = array(
            'pesan' => $pesan,
            'ket' => $ket
        );

        echo json_encode($output);
    }

    function laporan_prive() {
        $search = $this->input->post('search_omset');
        $toko = $this->input->post('pilihtoko');
        $tgl = explode(' - ', $this->input->post('tgl'));
        $tgl_awal = explode('/', $tgl[0]);
        $tglawal = $tgl_awal[2] . '-' . $tgl_awal[0] . '-' . $tgl_awal[1];
        $tgl_akhir = explode('/', $tgl[1]);
        $tglakhir = $tgl_akhir[2] . '-' . $tgl_akhir[0] . '-' . $tgl_akhir[1];
        $baris = $this->input->post('baris');
        $list = $this->Mlaporan->laporan_prive($search, $tglawal, $tglakhir, $toko, $baris);
        if (count($list) > 0) {
            $no = 1;
            foreach ($list as $value) {
                $row = array();
                if ($value->idcustomer == 0 || $value->idcustomer == "" || $value->jenis_harga_penjualan == "ecer") {
                    $nm_c = 'customer ecer (-)';
                    $print = "print_ecer";
                } else {
                    $nm_c = $value->nama_customer;
                    $print = "print_grosir";
                }
                $row[] = '<tr>';
                $row[] = '<td>' . $no++ . '</td>';
                $row[] = '<td>' . date('d-m-Y H:i:s ', strtotime($value->tanggal)) . '</td>';
                $row[] = '<td>' . $value->notatransaksi_penjualan_customer . '</td>';
                $row[] = '<td>' . $nm_c . '</td>';  
                if($value->jenis_bayar=="cicil"){
                    $row[] = '<td>Kredit</td>';
                }else{
                    $row[] = '<td>Tunai</td>';
                }
                
                $row[] = '<td>' . $value->idbarang . '</td>';
                $row[] = '<td>' . $value->nama_barang . '</td>';
                $row[] = '<td>' .$this->rupiah( $value->hargajual - $value->diskon) . '</td>';
                $row[] = '<td>' .$this->rupiah( $value->hargabeli) . '</td>';
                $row[] = '<td>' . $this->rupiah(( $value->hargajual - $value->diskon)-$value->hargabeli) . '</td>';
                $row[] = '<td>' . $this->rupiah(( $value->jumlah)) . '</td>';
                $row[] = '<td>' . $this->rupiah($value->laba) . '</td>';
                $row[] = '</tr>';
                $data[] = $row;
                $total_omset[]=(($value->hargajual - $value->diskon)*$value->jumlah) + $value->ongkir;
            }
//            $jum_omset = $this->Mlaporan->sum_total_penjualan($search, $tglawal, $tglakhir, $toko);
            $sukses = 'ya';
            $jum = $this->rupiah(array_sum($total_omset));
        } else {
            $sukses = 'tidak';
            $data = '<tr><td colspan="10"><span class="text-danger" style="text-transform: uppercase"><b><u> ' . $search . ' </u></b></span> Data kosong ! pastikan interval waktu benar atau kata pencarian sesuai data yang ada  </td></tr>';
            $jum = 0;
        }
        $output = array(
            'sukses' => $sukses,
            'list_omset' => $data,
            'jum_omset' => $jum
        );
        echo json_encode($output);
    }
    

    function laporan_kulakan() {
        $search = $this->input->post('search_omset');
        $toko = $this->input->post('pilihtoko');
        $tgl = explode(' - ', $this->input->post('tgl'));
        $tgl_awal = explode('/', $tgl[0]);
        $tglawal = $tgl_awal[2] . '-' . $tgl_awal[0] . '-' . $tgl_awal[1];
        $tgl_akhir = explode('/', $tgl[1]);
        $tglakhir = $tgl_akhir[2] . '-' . $tgl_akhir[0] . '-' . $tgl_akhir[1];
        $baris = $this->input->post('baris');
        $list = $this->Mlaporan->laporan_kulakan($search, $tglawal, $tglakhir, $toko, $baris);
        if (count($list) > 0) {
            $no = 1;
            foreach ($list as $value) {
                $row = array();
                
                $row[] = '<tr>';
                $row[] = '<td>' . $no++ . '</td>';
                $row[] = '<td>' . date('d-m-Y H:i:s ', strtotime($value->tanggal)) . '</td>';
                $row[] = '<td>' . $value->notatransaksi_kulakan  . '</td>';
                $row[] = '<td>' . $value->nama_suplayer . '</td>';  
                $row[] = '<td>' . $value->idbarang . '</td>';
                $row[] = '<td>' . $value->nama_barang . '</td>';
                $row[] = '<td>' .$this->rupiah( $value->hargabeli) . '</td>';
                $row[] = '<td>' . $this->rupiah(( $value->jumlah)) . '</td>';
                $row[] = '<td>' . $this->rupiah($value->hargabeli*$value->jumlah) . '</td>';
                
                $row[] = '</tr>';
                $data[] = $row;
                $total_omset[]=($value->hargabeli*$value->jumlah);
            }
            $sukses = 'ya';
            $jum = $this->rupiah(array_sum($total_omset));
        } else {
            $sukses = 'tidak';
            $data = '<tr><td colspan="10"><span class="text-danger" style="text-transform: uppercase"><b><u> ' . $tgl . ' </u></b></span> Data kosong ! pastikan interval waktu benar atau kata pencarian sesuai data yang ada  </td></tr>';
            $jum = 0;
        }
        $output = array(
            'sukses' => $sukses,
            'list_omset' => $data,
            'jum_omset' => $jum
        );
        echo json_encode($output);
    }
    function laporan_casback() {
        $search = $this->input->post('search_omset');
        $toko = $this->input->post('pilihtoko');
        $tgl = explode(' - ', $this->input->post('tgl'));
        $tgl_awal = explode('/', $tgl[0]);
        $tglawal = $tgl_awal[2] . '-' . $tgl_awal[0] . '-' . $tgl_awal[1];
        $tgl_akhir = explode('/', $tgl[1]);
        $tglakhir = $tgl_akhir[2] . '-' . $tgl_akhir[0] . '-' . $tgl_akhir[1];
        $baris = $this->input->post('baris');
        $list = $this->Mlaporan->laporan_casback($search, $tglawal, $tglakhir, $toko, $baris);
        if (count($list) > 0) {
            $no = 1;
            foreach ($list as $value) {
                $row = array();
                $row[] = '<tr>';
                $row[] = '<td>' . $no++ . '</td>';
                $row[] = '<td>' . date('d-m-Y H:i:s ', strtotime($value->tanggal)) . '</td>';
                $row[] = '<td>' . $value->keterangan . '</td>';
                $row[] = '<td>' . $value->nominal . '</td>';
                $row[] = '<td>' . $value->jenis . '</td>';
            
                $row[] = '</tr>';
                $data[] = $row;
                $total_omset[]=$value->nominal;
            }
            $sukses = 'ya';
            $jum = $this->rupiah(array_sum($total_omset));
        } else {
            $sukses = 'tidak';
            $data = '<tr><td colspan="5"><span class="text-danger" style="text-transform: uppercase"><b><u> ' . $search . ' </u></b></span> Data kosong ! pastikan interval waktu benar atau kata pencarian sesuai data yang ada  </td></tr>';
            $jum = 0;
        }
        $output = array(
            'sukses' => $sukses,
            'list_omset' => $data,
            'jum_omset' => $jum
        );
        echo json_encode($output);
    }
    //------------------------------------------------------------- laporan Omset
    function laporan_hakases() {

       $this->db->from('tbhakses'); 
       $sql=$this->db->get();
       $list = $sql->result();
            $menu="Master";
            foreach ($list as $value) {
                $row = array();
                if($value->Menu==$menu){
                    $row[] ='
                    
                    <tr class="bg bg-success"><td colspan="6"style="text-align: Center"> <b>'.$menu.'</td></tr>
                    <tr class="bg bg-success">
                    <th >Menu</th>
                   <th >Sub Item Menu</th>
                   <th >Pemilik</th>   
                   <th >Gudang</th>
                   <th >Kasir</th>  
                   <th >Supervisor</th>  
                   
               </tr>';
                    $menu="Transaksi"; 
                } 

                if($value->Menu==$menu){
                    // $row[] ='<tr><td colspan="6"style="text-align: Center"> <b>'.$menu.'</td></tr>';
                    $menu="Laporan"; 
                }   
                $row[] = '<tr>';            
                $row[] = '<td>' . $value->Menu . '</td>';
                $row[] = '<td>' . $value->Item . '</td>';
                if($value->Pemilik==0){
                    $row[] = '<td><button class="btn btn-danger" onclick="MenuPemilikAktif(' . $value->ID   . ')">Non-Aktif</button></td>';
                }else{
                    $row[] = '<td><button class="btn btn-primary" onclick="MenuPemilikNonAktif(' . $value->ID   . ')">Aktif</button></td>';
                }

                if($value->Admin_gudang==0){
                    $row[] = '<td><button class="btn btn-danger" onclick="MenuGudangAktif(' . $value->ID   . ')">Non-Aktif</button></td>';
                }else{
                    $row[] = '<td><button class="btn btn-primary" onclick="MenuGudangNonAktif(' . $value->ID   . ')">Aktif</button></td>';
                }

                if($value->Kasir_toko==0){
                    $row[] = '<td><button class="btn btn-danger" onclick="MenuKasirAktif(' . $value->ID   . ')">Non-Aktif</button></td>';
                }else{
                    $row[] = '<td><button class="btn btn-primary" onclick="MenuKasirNonAktif(' . $value->ID   . ')">Aktif</button></td>';
                }

                if($value->Supervisor==0){
                    $row[] = '<td><button class="btn btn-danger" >Non-Aktif</button></td>';
                }else{
                    $row[] = '<td><button class="btn btn-primary" >Aktif</button></td>';
                }

                
                
                
                $row[] = '</tr>';
                $data[] = $row;

            }
            $sukses = 'ya';
            $jum = '0';
        $output = array(
            'sukses' => $sukses,
            'list_omset' => $data,
            'jum_omset' => $jum
        );
        echo json_encode($output);
    }
    function laporan_omset() {
        $search = $this->input->post('search_omset');
        $toko = $this->input->post('pilihtoko');
        $tgl = explode(' - ', $this->input->post('tgl'));
        $tgl_awal = explode('/', $tgl[0]);
        $tglawal = $tgl_awal[2] . '-' . $tgl_awal[0] . '-' . $tgl_awal[1];
        $tgl_akhir = explode('/', $tgl[1]);
        $tglakhir = $tgl_akhir[2] . '-' . $tgl_akhir[0] . '-' . $tgl_akhir[1];
        $baris = $this->input->post('baris');
        $list = $this->Mlaporan->laporan_omset($search, $tglawal, $tglakhir, $toko, $baris);
        if (count($list) > 0) {
            $no = 1;
            foreach ($list as $value) {
                $row = array();
                if ($value->idcustomer == 0 || $value->idcustomer == "" || $value->jenis_harga_penjualan == "ecer") {
                    $nm_c = 'customer ecer (-)';
                    $print = "print_ecer";
                } else {
                    $nm_c = $value->nama_customer;
                    $print = "print_grosir";
                }
                $row[] = '<tr>';
                $row[] = '<td>' . $no++ . '</td>';
                $row[] = '<td>' . date('d-m-Y H:i:s ', strtotime($value->tanggal)) . '</td>';
                $row[] = '<td>' . $value->notatransaksi_penjualan_customer . '</td>';
                $row[] = '<td>' . $value->jenis_harga_penjualan . '</td>';
                $row[] = '<td>' . $value->nama . '</td>';
                $row[] = '<td>' . $value->nama_marketing . '</td>';
                $row[] = '<td>' . $nm_c . '</td>';
                $row[] = '<td>' . $this->rupiah($value->totalbayar + $value->ongkir) . '</td>';
                $row[] = '<td><a href="#" onclick="' . $print . '(`' . $value->notatransaksi_penjualan_customer . '`)"><i class="fas fa-print"></i>Print</button></a>
                </td>';
                $row[] = '<td><a href="#" data-toggle="modal" data-target="#modal-lg" onclick="info_nota(`' . $value->notatransaksi_penjualan_customer . '`)"><i class="fas fa-search"></i></button></a></td>';
                $row[] = '</tr>';
                $data[] = $row;
                $total_omset[]=$value->totalbayar + $value->ongkir;
            }
            $sukses = 'ya';
            $jum = $this->rupiah(array_sum($total_omset));
        } else {
            $sukses = 'tidak';
            $data = '<tr><td colspan="10"><span class="text-danger" style="text-transform: uppercase"><b><u> ' . $search . ' </u></b></span> Data kosong ! pastikan interval waktu benar atau kata pencarian sesuai data yang ada  </td></tr>';
            $jum = 0;
        }
        $output = array(
            'sukses' => $sukses,
            'list_omset' => $data,
            'jum_omset' => $jum
        );
        echo json_encode($output);
    }
    function laporan_kas() {
        $search = $this->input->post('search_block_stock');
        $toko = $this->input->post('pilihtoko');
        $tgl = explode(' - ', $this->input->post('tgl'));
        $tgl_awal = explode('/', $tgl[0]);
        $tglawal = $tgl_awal[2] . '-' . $tgl_awal[0] . '-' . $tgl_awal[1];
        $tgl_akhir = explode('/', $tgl[1]);
        $tglakhir = $tgl_akhir[2] . '-' . $tgl_akhir[0] . '-' . $tgl_akhir[1];
        $baris = $this->input->post('baris');
        $list = $this->Mlaporan->laporan_kas($search, $tglawal, $tglakhir, $toko, $baris);
        if (count($list) > 0) {
            $no = 1;
            foreach ($list as $value) {
                $row = array();
                
                $row[] = '<tr>';
                $row[] = '<td>' . $no++ . '</td>';
                $row[] = '<td>' . $value->tgl . '</td>';
                $row[] = '<td>' . $value->ket . '</td>';
                $row[] = '<td>' . $this->rupiah($value->saldo_awal) . '</td>';
                $row[] = '<td>' . $this->rupiah($value->Masuk) . '</td>';
                $row[] = '<td>' . $this->rupiah($value->Keluar) . '</td>';
                $row[] = '<td>' . $this->rupiah($value->koreksi) . '</td>';
                $row[] = '<td>' . $this->rupiah($value->saldo_akhir) . '</td>';
                $row[] = '</tr>';
                $data[] = $row;
                $total_block_stock=$value->saldo_akhir ;
            }
//            $jum_block_stock = $this->Mlaporan->sum_total_penjualan($search, $tglawal, $tglakhir, $toko);
            $sukses = 'ya';
            $jum = $this->rupiah(($total_block_stock));
        } else {
            $sukses = 'tidak';
            $data = '<tr><td colspan="10"><span class="text-danger" style="text-transform: uppercase"><b><u> ' . $search . ' </u></b></span> Data kosong ! pastikan interval waktu benar atau kata pencarian sesuai data yang ada  </td></tr>';
            $jum = 0;
        }
        $output = array(
            'sukses' => $sukses,
            'list_block_stock' => $data,
            'jum_block_stock' => $jum
        );
        echo json_encode($output);
    }
    
    function laporan_opname_stock() {
        $tgl = explode(' - ', $this->input->post('tgl'));
        $tgl_awal = explode('/', $tgl[0]);
        $tglawal = $tgl_awal[2] . '-' . $tgl_awal[0] . '-' . $tgl_awal[1];
        $tgl_akhir = explode('/', $tgl[1]);
        $tglakhir = $tgl_akhir[2] . '-' . $tgl_akhir[0] . '-' . $tgl_akhir[1];
        $list = $this->Mlaporan->laporan_opname_stock( $tglawal, $tglakhir);
        if (count($list) > 0) {
            $no = 1;
            foreach ($list as $value) {
                $row = array();
                $row[] = '<tr>';
                $row[] = '<td>' . $value->nama . '</td>';
                $row[] = '<td>' . $value->tanggal_stock_opname . '</td>';
                $row[] = '<td>' . $value->idbarang . '</td>';
                $row[] = '<td>' . $value->nama_barang . '</td>';
                $row[] = '<td>' . $value->barcode . '</td>';
                $row[] = '<td>' . $value->stock . '</td>';
                $row[] = '<td>' . $value->opname . '</td>';
                $row[] = '<td>' . $value->selisi . '</td>';
                $row[] = '<td>' . $value->harga . '</td>';
                $row[] = '<td>' . $value->total_selisih . '</td>';
                $row[] = '</tr>';
                $data[] = $row;
            }
            $sukses = 'ya';
            $jum='0';
        } else {
            $sukses = 'tidak';
            $data = '<tr><td colspan="10"><span class="text-danger" style="text-transform: uppercase"><b><u> ' . $search . ' </u></b></span> Data kosong ! pastikan interval waktu benar atau kata pencarian sesuai data yang ada  </td></tr>';
            $jum = 0;
        }
        $output = array(
            'sukses' => $sukses,
            'list_block_stock' => $data,
            'jum_block_stock' => $jum
        );
        echo json_encode($output);
    }
    function laporan_retur_suplayer() {
        $search = $this->input->post('search_block_stock');
        $toko = $this->input->post('pilihtoko');
        $tgl = explode(' - ', $this->input->post('tgl'));
        $tgl_awal = explode('/', $tgl[0]);
        $tglawal = $tgl_awal[2] . '-' . $tgl_awal[0] . '-' . $tgl_awal[1];
        $tgl_akhir = explode('/', $tgl[1]);
        $tglakhir = $tgl_akhir[2] . '-' . $tgl_akhir[0] . '-' . $tgl_akhir[1];
        $baris = $this->input->post('baris');
        $list = $this->Mlaporan->laporan_retur_suplayer($search, $tglawal, $tglakhir, $toko, $baris);
        if (count($list) > 0) {
            $no = 1;
            foreach ($list as $value) {
                $row = array();
                
                $row[] = '<tr>';
                $row[] = '<td>' . date('d-m-Y H:i:s ', strtotime($value->tanggal)) . '</td>';
                $row[] = '<td>' . $value->notasuplayer . '</td>';
                $row[] = '<td>' . $value->idbarang . '</td>';
                $row[] = '<td>' . $value->nama_barang . '</td>';
                $row[] = '<td>' . $this->rupiah($value->harga_jual) . '</td>';
                $row[] = '<td>' . $value->jumlah . '</td>';
                $row[] = '<td>' .$this->rupiah( $value->total_retur) . '</td>';
                 $row[] = '</tr>';
                $data[] = $row;
                $total_block_stock[]=$value->total_retur;
            }
            $sukses = 'ya';
            $jum = $this->rupiah(array_sum($total_block_stock));
        } else {
            $sukses = 'tidak';
            $data = '<tr><td colspan="10"><span class="text-danger" style="text-transform: uppercase"><b><u> ' . $search . ' </u></b></span> Data kosong ! pastikan interval waktu benar atau kata pencarian sesuai data yang ada  </td></tr>';
            $jum = 0;
        }
        $output = array(
            'sukses' => $sukses,
            'list_block_stock' => $data,
            'jum_block_stock' => $jum
        );
        echo json_encode($output);
    }

    function laporan_retur_customer() {
        $search = $this->input->post('search_block_stock');
        $toko = $this->input->post('pilihtoko');
        $tgl = explode(' - ', $this->input->post('tgl'));
        $tgl_awal = explode('/', $tgl[0]);
        $tglawal = $tgl_awal[2] . '-' . $tgl_awal[0] . '-' . $tgl_awal[1];
        $tgl_akhir = explode('/', $tgl[1]);
        $tglakhir = $tgl_akhir[2] . '-' . $tgl_akhir[0] . '-' . $tgl_akhir[1];
        $baris = $this->input->post('baris');
        $list = $this->Mlaporan->laporan_retur_customer($search, $tglawal, $tglakhir, $toko, $baris);
        if (count($list) > 0) {
            $no = 1;
            foreach ($list as $value) {
                $row = array();
                
                $row[] = '<tr>';
                $row[] = '<td>' . date('d-m-Y H:i:s ', strtotime($value->tanggal)) . '</td>';
                $row[] = '<td>' . $value->notacustomer . '</td>';
                $row[] = '<td>' . $value->idbarang . '</td>';
                $row[] = '<td>' . $value->nama_barang . '</td>';
                $row[] = '<td>' . $this->rupiah($value->harga_jual) . '</td>';
                $row[] = '<td>' . $value->jumlah . '</td>';
                $row[] = '<td>' .$this->rupiah( $value->total_retur) . '</td>';
                 $row[] = '</tr>';
                $data[] = $row;
                $total_block_stock[]=$value->total_retur;
            }
            $sukses = 'ya';
            $jum = $this->rupiah(array_sum($total_block_stock));
        } else {
            $sukses = 'tidak';
            $data = '<tr><td colspan="10"><span class="text-danger" style="text-transform: uppercase"><b><u> ' . $search . ' </u></b></span> Data kosong ! pastikan interval waktu benar atau kata pencarian sesuai data yang ada  </td></tr>';
            $jum = 0;
        }
        $output = array(
            'sukses' => $sukses,
            'list_block_stock' => $data,
            'jum_block_stock' => $jum
        );
        echo json_encode($output);
    }
    function laporan_block_stock() {
        $search = $this->input->post('search_block_stock');
        $toko = '2';
        $tgl = explode(' - ', $this->input->post('tgl'));
        $tgl_awal = explode('/', $tgl[0]);
        $tglawal = $tgl_awal[2] . '-' . $tgl_awal[0] . '-' . $tgl_awal[1];
        $tgl_akhir = explode('/', $tgl[1]);
        $tglakhir = $tgl_akhir[2] . '-' . $tgl_akhir[0] . '-' . $tgl_akhir[1];
        $baris = $this->input->post('baris');
        $list = $this->Mlaporan->laporan_block_stock($search, $tglawal, $tglakhir, $toko, $baris);
        if (count($list) > 0) {
            $no = 1;
            foreach ($list as $value) {
                $row = array();
                if ($value->idcustomer == 0 || $value->idcustomer == "" || $value->jenis_harga_penjualan == "ecer") {
                    $nm_c = 'customer ecer (-)';
                    $print = "print_ecer";
                } else {
                    $nm_c = $value->nama_customer;
                    $print = "print_grosir";
                }
                $row[] = '<tr>';
                $row[] = '<td>' . $no++ . '</td>';
                $row[] = '<td>' . date('d-m-Y H:i:s ', strtotime($value->tanggal)) . '</td>';
                $row[] = '<td>' . $value->notatransaksi_penjualan_customer . '</td>';
                $row[] = '<td>' . $value->jenis_harga_penjualan . '</td>';
                $row[] = '<td>' . $value->nama . '</td>';
                $row[] = '<td>' . $nm_c . '</td>';
                $row[] = '<td>' . $this->rupiah($value->totalbayar + $value->ongkir) . '</td>';
                $row[] = '<td><a href="#" onclick="' . $print . '(`' . $value->notatransaksi_penjualan_customer . '`)"><i class="fas fa-print"></i>Print</button></a>
                </td>';
                $row[] = '<td><a href="#" data-toggle="modal" data-target="#modal-lg" onclick="info_nota(`' . $value->notatransaksi_penjualan_customer . '`)"><i class="fas fa-search"></i></button></a></td>';
                $row[] = '<td> <button class="btn btn-danger" onclick="ambil_block_stock(`' . $value->notatransaksi_penjualan_customer . '`)">Ambil Bloc Stock</button></td>';
                $row[] = '</tr>';
                $data[] = $row;
                $total_block_stock[]=$value->totalbayar + $value->ongkir;
            }
//            $jum_block_stock = $this->Mlaporan->sum_total_penjualan($search, $tglawal, $tglakhir, $toko);
            $sukses = 'ya';
            $jum = $this->rupiah(array_sum($total_block_stock));
        } else {
            $sukses = 'tidak';
            $data = '<tr><td colspan="10"><span class="text-danger" style="text-transform: uppercase"><b><u> ' . $search . ' </u></b></span> Data kosong ! pastikan interval waktu benar atau kata pencarian sesuai data yang ada  </td></tr>';
            $jum = 0;
        }
        $output = array(
            'sukses' => $sukses,
            'list_block_stock' => $data,
            'jum_block_stock' => $jum
        );
        echo json_encode($output);
    }
//--------------------------------------------------------------- laporan income
    function laporan_income() {
        $search = $this->input->post('search_income');
        $toko = $this->input->post('pilihtoko');
        $tgl = explode(' - ', $this->input->post('tgl'));
        $tgl_awal = explode('/', $tgl[0]);
        $tglawal = $tgl_awal[2] . '-' . $tgl_awal[0] . '-' . $tgl_awal[1];
        $tgl_akhir = explode('/', $tgl[1]);
        $tglakhir = $tgl_akhir[2] . '-' . $tgl_akhir[0] . '-' . $tgl_akhir[1];
        $baris = $this->input->post('baris');
        $list = $this->Mlaporan->laporan_income($search, $tglawal, $tglakhir, $toko, $baris);
        if (count($list) > 0) {

            $no = 1;
            foreach ($list as $value) {
                $laba = $this->Mlaporan->total_laba($value->notatransaksi_penjualan_customer);
                $row = array();
                if ($value->idcustomer == 0 || $value->idcustomer == "") {
                    $nm_c = 'customer ecer (-)';
                } else {
                    $nm_c = $value->nama_customer;
                }
                $row[] = '<tr>';
                $row[] = '<td>' . $no++ . '</td>';
                $row[] = '<td>' . date('d-m-Y H:i:s ', strtotime($value->tanggal)) . '</td>';
                $row[] = '<td>' . $value->notatransaksi_penjualan_customer . '</td>';
                $row[] = '<td>' . $value->jenis_harga_penjualan . '</td>';
                $row[] = '<td>' . $value->nama . '</td>';
                $row[] = '<td>' . $value->nama_marketing . '</td>';
                $row[] = '<td>' . $nm_c . '</td>';
                $row[] = '<td>' . $this->rupiah($laba['laba']) . '</td>';
                $row[] = '</tr>';
                $data[] = $row;
                $total_laba[] = $laba['laba'];
            }
//             $jum_income = $this->Mlaporan->sum_total_laba($search, $tglawal, $tglakhir, $toko);
            $sukses = 'ya';
            $jum = $this->rupiah(array_sum($total_laba));
            
        $biaya = $this->Mlaporan->laporan_pengeluaran($tglawal, $tglakhir, $toko);    
            
            $pengeluaran=$this->rupiah($biaya->pengeluaran);
            $laba_bersih=$this->rupiah(array_sum($total_laba)-$biaya->pengeluaran);
            
            
            
        } else {
            $sukses = 'tidak';
            $data = '<tr><td colspan="8"><span class="text-danger" style="text-transform: uppercase"><b><u> ' . $search . ' </u></b></span> Data kosong ! pastikan interval waktu benar atau kata pencarian sesuai data yang ada  </td></tr>';
            $jum = 0;
            $pengeluaran=0;
            $laba_bersih=0;
        }
        $output = array(
            'sukses' => $sukses,
            'list_income' => $data,
            'jum_income' => $jum,
            'jum_pengeluaran' => $pengeluaran,
            'jum_bersih' => $laba_bersih,
            
        );
        echo json_encode($output);
    }

}
