<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <title>Invoice</title>
    <style>
        @page {
            size: auto;
            margin: 0;
        }

        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
            font-family: Arial, sans-serif;
            font-size: 8pt;
            color: #333;
        }

        body {
            width: 100%;
            background: #f4f6f9;
            padding: 5mm 0;
        }

        #wrapper {
            width: 44mm;
            margin: 0 auto;
            background: #ffffff;
            border-radius: 3px;
            box-shadow: 0 0 4px rgba(0,0,0,.15);
            padding-bottom: 3mm;
        }

        #invoice_head {
            padding: 3mm 3mm 1mm 3mm;
            border-bottom: 1px dashed #bdc3c7;
            background: linear-gradient(to right, #3498db, #2ecc71);
            color: #ffffff;
        }

        #invoice_head table {
            width: 100%;
            border-collapse: collapse;
        }

        #invoice_head td {
            padding: 0;
            text-align: center;
        }

        .store-name {
            font-size: 9pt;
            font-weight: bold;
            letter-spacing: 0.5px;
        }

        .store-sub {
            font-size: 7pt;
            opacity: 0.9;
        }

        .info-table {
            width: 100%;
            border-collapse: collapse;
            padding: 2mm 3mm;
        }

        .info-table td {
            padding: 1mm 3mm 0 3mm;
            font-size: 7pt;
        }

        .label {
            color: #7f8c8d;
        }

        #content {
            padding: 1mm 3mm 0 3mm;
        }

        #invoice_body table {
            width: 100%;
            border-collapse: collapse;
            margin-top: 1mm;
        }

        #invoice_body thead th {
            font-size: 7pt;
            padding: 1mm 0;
            border-bottom: 1px solid #bdc3c7;
            text-align: center;
            background: #ecf6ff;
        }

        #invoice_body tbody td {
            padding: 1mm 0;
            border-bottom: 1px dotted #ecf0f1;
        }

        #invoice_body td:nth-child(1) {
            text-align: left;
        }

        #invoice_body td:nth-child(2),
        #invoice_body td:nth-child(3) {
            text-align: center;
        }

        #invoice_body td:nth-child(4) {
            text-align: right;
        }

        #invoice_total {
            padding: 2mm 3mm 0 3mm;
        }

        #invoice_total table {
            width: 100%;
            border-collapse: collapse;
        }

        #invoice_total td {
            padding: 1.5mm 0;
            font-size: 8pt;
        }

        .total-label {
            text-align: left;
            font-weight: bold;
            color: #2c3e50;
        }

        .total-value {
            text-align: right;
            font-weight: bold;
            color: #e74c3c;
        }

        .total-row {
            border-top: 1px solid #bdc3c7;
            border-bottom: 1px solid #bdc3c7;
            background: #fdf2f2;
        }

        .thankyou {
            text-align: center;
            padding-top: 2mm;
            font-size: 7pt;
            color: #7f8c8d;
        }

        .btn-wrapper {
    text-align: center;
    margin-top: 3mm;
}

.btn-back,
.btn-send,
.btn-download {
    display: inline-block;
    padding: 2mm 5mm;
    font-size: 8pt;
    border-radius: 3px;
    border: none;
    cursor: pointer;
    color: #ffffff;
    margin: 0 1mm;
}

/* Kirim Nota (WA) */
.btn-send {
    background: #25D366; /* warna WA */
}
.btn-send:hover {
    background: #1da852;
}

/* Download PDF */
.btn-download {
    background: #e67e22;
}
.btn-download:hover {
    background: #d35400;
}

/* Kembali */
.btn-back {
    background: #7f8c8d;
}
.btn-back:hover {
    background: #636e72;
}

@media print {
    .btn-wrapper {
        display: none; /* tombol tidak ikut ke print */
    }
}
   </style>
    <script>
        function goBack() {
            window.history.back();
        }
    </script>
</head>
<body>
    <div id="wrapper">

        <!-- HEADER TOKO -->
        <div id="invoice_head">
            <table>
                <tr>
                    <td>
                        <div class="store-name"><?= $penjualan->nama ?></div>
                        <!-- Kalau mau alamat/no telp, bisa tambahkan di sini -->
                        <!-- <div class="store-sub">Jl. Contoh No. 123 - 08xx-xxxx-xxxx</div> -->
                    </td>
                </tr>
            </table>
        </div>

        <!-- INFO NOTA -->
        <table class="info-table">
            <tr>
                <td class="label">Nota</td>
                <td style="text-align:right;"><strong><?= $penjualan->notatransaksi_penjualan_customer ?></strong></td>
            </tr>
            <tr>
                <td class="label">Tanggal</td>
                <td style="text-align:right;"><strong><?= date('d-m-Y', strtotime($penjualan->tanggal)) ?></strong></td>
            </tr>
        </table>

        <div id="content">
            <!-- DETAIL BARANG -->
            <div id="invoice_body">
                <table>
                    <thead>
                        <tr>
                            <th colspan="3" style="width:40%; text-align:left;">Detail Barang</th>
                            
                        </tr>
                    </thead>
                    <tbody>
                        <?php foreach ($detail_penjualan as $value): ?>
                            <tr>
                                <td colspan="3"><?= $value->nama_barang ?></td>
                            </tr>
                            <tr>
                                <td><?= "Rp " . number_format($value->hargajual, 0, ',', '.') ?></td>
                                <td><?= $value->jumlah ?></td>
                                <td><?= "Rp " . number_format($value->jumlah * $value->hargajual, 0, ',', '.') ?></td>
                            </tr>
                        <?php endforeach; ?>
                    </tbody>
                </table>
            </div>

            <!-- TOTAL -->
            <div id="invoice_total">
                <table>
                    <tr class="total-row">
                        <td class="total-label">Total</td>
                        <td class="total-value"><?= "Rp " . number_format($penjualan->totalbayar, 0, ',', '.') ?></td>
                    </tr>
                </table>
            </div>

            <!-- UCAPAN -->
            <div class="thankyou">
                Terima kasih atas kunjungan Anda
            </div>

            <!-- TOMBOL KEMBALI (Hanya tampil di layar, tidak di print) -->
            <div class="btn-wrapper">
                <button type="button" class="btn-send" onclick="sendNotaWa()">Kirim Nota</button>
                 <button type="button" class="btn-download" onclick="downloadPDF()">Download PDF</button>
                <button type="button" class="btn-back" onclick="goBack()">Kembali</button>
            </div>
        </div>

    </div>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/html2pdf.js/0.9.3/html2pdf.bundle.min.js"></script>

    <script>
    function sendNotaWa() {
        // teks nota (isi dari PHP)
        var text = 
            "Nota: <?= $penjualan->notatransaksi_penjualan_customer ?>\n" +
            "Tanggal: <?= date('d-m-Y', strtotime($penjualan->tanggal)) ?>\n" +
            "Total: <?= 'Rp ' . number_format($penjualan->totalbayar, 0, ',', '.') ?>\n\n" +
            "Detail:\n" +
            <?php
            $rows = [];
            foreach ($detail_penjualan as $value) {
                $rows[] = $value->nama_barang . " x" . $value->jumlah . " @Rp " . number_format($value->hargajual, 0, ',', '.');
            }
            ?>
            "<?= implode('\\n', $rows); ?>";

        // TANPA nomor → user pilih kontak sendiri di WhatsApp
        var url = "https://api.whatsapp.com/send?text=" + encodeURIComponent(text);

        // di HP akan buka aplikasi WhatsApp, di desktop buka WhatsApp Web
        window.open(url, "_blank");
    }
    function goBack() {
        // Kalau ada halaman sebelumnya di history, balik ke sana
        if (window.history.length > 1) {
            window.history.back();
        } else {
            // Kalau nggak ada, coba tutup tab
            window.close();
        }
    }
    function downloadPDF() {
        // elemen yang mau dijadikan PDF (nota saja)
        var element = document.getElementById('wrapper');

        var opt = {
            margin:       5, // margin dalam PDF (mm, kira-kira)
            filename:     'Nota-<?= $penjualan->notatransaksi_penjualan_customer ?>.pdf',
            image:        { type: 'jpeg', quality: 0.98 },
            html2canvas:  { scale: 2 },
            jsPDF:        { unit: 'mm', format: 'a4', orientation: 'portrait' }
            // kalau mau ukuran mirip struk kecil, nanti bisa diubah ke format custom
            // misal: format: [44, 200]
        };

        html2pdf().set(opt).from(element).save();
    }
</script>
</body>

</html>
